/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.io;

import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.KeyValueSerializer;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.io.DataFilePathFactory;
import org.apache.flink.table.store.file.io.KeyValueDataFileWriter;
import org.apache.flink.table.store.file.io.RollingFileWriter;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.store.format.FileStatsExtractor;
import org.apache.flink.table.types.logical.RowType;

public class KeyValueFileWriterFactory {
    private final long schemaId;
    private final RowType keyType;
    private final RowType valueType;
    private final BulkWriter.Factory<RowData> writerFactory;
    @Nullable
    private final FileStatsExtractor fileStatsExtractor;
    private final DataFilePathFactory pathFactory;
    private final long suggestedFileSize;

    private KeyValueFileWriterFactory(long schemaId, RowType keyType, RowType valueType, BulkWriter.Factory<RowData> writerFactory, @Nullable FileStatsExtractor fileStatsExtractor, DataFilePathFactory pathFactory, long suggestedFileSize) {
        this.schemaId = schemaId;
        this.keyType = keyType;
        this.valueType = valueType;
        this.writerFactory = writerFactory;
        this.fileStatsExtractor = fileStatsExtractor;
        this.pathFactory = pathFactory;
        this.suggestedFileSize = suggestedFileSize;
    }

    public RowType keyType() {
        return this.keyType;
    }

    public RowType valueType() {
        return this.valueType;
    }

    @VisibleForTesting
    public DataFilePathFactory pathFactory() {
        return this.pathFactory;
    }

    public RollingFileWriter<KeyValue, DataFileMeta> createRollingMergeTreeFileWriter(int level) {
        return new RollingFileWriter<KeyValue, DataFileMeta>(() -> this.createDataFileWriter(this.pathFactory.newPath(), level), this.suggestedFileSize);
    }

    public RollingFileWriter<KeyValue, DataFileMeta> createRollingChangelogFileWriter(int level) {
        return new RollingFileWriter<KeyValue, DataFileMeta>(() -> this.createDataFileWriter(this.pathFactory.newChangelogPath(), level), this.suggestedFileSize);
    }

    private KeyValueDataFileWriter createDataFileWriter(Path path, int level) {
        KeyValueSerializer kvSerializer = new KeyValueSerializer(this.keyType, this.valueType);
        return new KeyValueDataFileWriter(this.writerFactory, path, kvSerializer::toRow, this.keyType, this.valueType, this.fileStatsExtractor, this.schemaId, level);
    }

    public void deleteFile(String filename) {
        FileUtils.deleteOrWarn(this.pathFactory.toPath(filename));
    }

    public static Builder builder(long schemaId, RowType keyType, RowType valueType, FileFormat fileFormat, FileStorePathFactory pathFactory, long suggestedFileSize) {
        return new Builder(schemaId, keyType, valueType, fileFormat, pathFactory, suggestedFileSize);
    }

    public static class Builder {
        private final long schemaId;
        private final RowType keyType;
        private final RowType valueType;
        private final FileFormat fileFormat;
        private final FileStorePathFactory pathFactory;
        private final long suggestedFileSize;

        private Builder(long schemaId, RowType keyType, RowType valueType, FileFormat fileFormat, FileStorePathFactory pathFactory, long suggestedFileSize) {
            this.schemaId = schemaId;
            this.keyType = keyType;
            this.valueType = valueType;
            this.fileFormat = fileFormat;
            this.pathFactory = pathFactory;
            this.suggestedFileSize = suggestedFileSize;
        }

        public KeyValueFileWriterFactory build(BinaryRowData partition, int bucket) {
            RowType recordType = KeyValue.schema(this.keyType, this.valueType);
            return new KeyValueFileWriterFactory(this.schemaId, this.keyType, this.valueType, this.fileFormat.createWriterFactory(recordType), this.fileFormat.createStatsExtractor(recordType).orElse(null), this.pathFactory.createDataFilePathFactory(partition, bucket), this.suggestedFileSize);
        }
    }
}

