/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ShowOperation;

public class ShowColumnsOperation
implements ShowOperation {
    private final ObjectIdentifier tableIdentifier;
    private final boolean useLike;
    private final boolean notLike;
    private final String likePattern;
    private final String preposition;

    public ShowColumnsOperation(ObjectIdentifier tableIdentifier, String likePattern, boolean useLike, boolean notLike, String preposition) {
        this.tableIdentifier = tableIdentifier;
        this.likePattern = likePattern;
        this.useLike = useLike;
        this.notLike = notLike;
        this.preposition = preposition;
    }

    public String getLikePattern() {
        return this.likePattern;
    }

    public String getPreposition() {
        return this.preposition;
    }

    public boolean isUseLike() {
        return this.useLike;
    }

    public boolean isNotLike() {
        return this.notLike;
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    @Override
    public String asSummaryString() {
        if (this.useLike) {
            if (this.notLike) {
                return String.format("SHOW COLUMNS %s %s %s LIKE '%s'", this.preposition, this.tableIdentifier.asSummaryString(), "NOT", this.likePattern);
            }
            return String.format("SHOW COLUMNS %s %s LIKE '%s'", this.preposition, this.tableIdentifier.asSummaryString(), this.likePattern);
        }
        return String.format("SHOW COLUMNS %s %s", this.preposition, this.tableIdentifier.asSummaryString());
    }
}

