/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.conversion;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.conversion.ArrayObjectArrayConverter;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.types.DataType;

@Internal
public class MapMapConverter<K, V>
implements DataStructureConverter<MapData, Map<K, V>> {
    private static final long serialVersionUID = 1L;
    private final ArrayObjectArrayConverter<K> keyConverter;
    private final ArrayObjectArrayConverter<V> valueConverter;
    private final boolean hasInternalEntries;

    private MapMapConverter(ArrayObjectArrayConverter<K> keyConverter, ArrayObjectArrayConverter<V> valueConverter) {
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
        this.hasInternalEntries = keyConverter.hasInternalElements && valueConverter.hasInternalElements;
    }

    @Override
    public void open(ClassLoader classLoader) {
        this.keyConverter.open(classLoader);
        this.valueConverter.open(classLoader);
    }

    @Override
    public MapData toInternal(Map<K, V> external) {
        if (this.hasInternalEntries) {
            return new GenericMapData(external);
        }
        return this.toBinaryMapData(external);
    }

    @Override
    public Map<K, V> toExternal(MapData internal) {
        ArrayData keyArray = internal.keyArray();
        ArrayData valueArray = internal.valueArray();
        int length = internal.size();
        HashMap map = new HashMap();
        for (int pos = 0; pos < length; ++pos) {
            Object keyValue = this.keyConverter.elementGetter.getElementOrNull(keyArray, pos);
            Object valueValue = this.valueConverter.elementGetter.getElementOrNull(valueArray, pos);
            map.put(this.keyConverter.elementConverter.toExternalOrNull(keyValue), this.valueConverter.elementConverter.toExternalOrNull(valueValue));
        }
        return map;
    }

    private MapData toBinaryMapData(Map<K, V> external) {
        int length = external.size();
        this.keyConverter.allocateWriter(length);
        this.valueConverter.allocateWriter(length);
        int pos = 0;
        for (Map.Entry<K, V> entry : external.entrySet()) {
            this.keyConverter.writeElement(pos, entry.getKey());
            this.valueConverter.writeElement(pos, entry.getValue());
            ++pos;
        }
        return BinaryMapData.valueOf(this.keyConverter.completeWriter(), this.valueConverter.completeWriter());
    }

    public static MapMapConverter<?, ?> createForMapType(DataType dataType) {
        DataType keyDataType = dataType.getChildren().get(0);
        DataType valueDataType = dataType.getChildren().get(1);
        return new MapMapConverter(ArrayObjectArrayConverter.createForElement(keyDataType), ArrayObjectArrayConverter.createForElement(valueDataType));
    }

    public static MapMapConverter<?, ?> createForMultisetType(DataType dataType) {
        DataType keyDataType = dataType.getChildren().get(0);
        DataType valueDataType = (DataType)DataTypes.INT().notNull();
        return new MapMapConverter(ArrayObjectArrayConverter.createForElement(keyDataType), ArrayObjectArrayConverter.createForElement(valueDataType));
    }
}

