/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterables;
import org.apache.flink.streaming.api.operators.util.SimpleVersionedListState;
import org.apache.flink.streaming.runtime.operators.sink.SinkWriterStateHandler;
import org.apache.flink.util.CollectionUtil;

@Internal
final class StatefulSinkWriterStateHandler<InputT, WriterStateT>
implements SinkWriterStateHandler<InputT> {
    private static final ListStateDescriptor<byte[]> WRITER_RAW_STATES_DESC = new ListStateDescriptor<byte[]>("writer_raw_states", BytePrimitiveArraySerializer.INSTANCE);
    private final SimpleVersionedSerializer<WriterStateT> writerStateSimpleVersionedSerializer;
    private final Collection<String> previousSinkStateNames;
    private final StatefulSink<InputT, WriterStateT> sink;
    private List<ListState<WriterStateT>> previousSinkStates = new ArrayList<ListState<WriterStateT>>();
    private ListState<WriterStateT> writerState;
    private StatefulSink.StatefulSinkWriter<InputT, WriterStateT> sinkWriter;

    public StatefulSinkWriterStateHandler(StatefulSink<InputT, WriterStateT> sink) {
        this.sink = sink;
        List previousSinkStateNames = sink instanceof StatefulSink.WithCompatibleState ? ((StatefulSink.WithCompatibleState)((Object)sink)).getCompatibleWriterStateNames() : Collections.emptyList();
        this.writerStateSimpleVersionedSerializer = sink.getWriterStateSerializer();
        this.previousSinkStateNames = previousSinkStateNames;
    }

    @Override
    public SinkWriter<InputT> createWriter(Sink.InitContext initContext, StateInitializationContext context) throws Exception {
        ListState<byte[]> rawState = context.getOperatorStateStore().getListState(WRITER_RAW_STATES_DESC);
        this.writerState = new SimpleVersionedListState<WriterStateT>(rawState, this.writerStateSimpleVersionedSerializer);
        if (context.isRestored()) {
            List writerStates = CollectionUtil.iterableToList((Iterable)this.writerState.get());
            ArrayList states = new ArrayList(writerStates);
            for (String previousSinkStateName : this.previousSinkStateNames) {
                ListStateDescriptor<byte[]> preSinkStateDesc = new ListStateDescriptor<byte[]>(previousSinkStateName, BytePrimitiveArraySerializer.INSTANCE);
                ListState<byte[]> preRawState = context.getOperatorStateStore().getListState(preSinkStateDesc);
                SimpleVersionedListState<WriterStateT> previousSinkState = new SimpleVersionedListState<WriterStateT>(preRawState, this.writerStateSimpleVersionedSerializer);
                this.previousSinkStates.add(previousSinkState);
                Iterables.addAll(states, previousSinkState.get());
            }
            this.sinkWriter = this.sink.restoreWriter(initContext, states);
        } else {
            this.sinkWriter = this.sink.createWriter(initContext);
        }
        return this.sinkWriter;
    }

    @Override
    public void snapshotState(long checkpointId) throws Exception {
        this.writerState.update(this.sinkWriter.snapshotState(checkpointId));
        this.previousSinkStates.forEach(State::clear);
    }
}

