/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointScheduling;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.util.Preconditions;

class CheckpointSchedulingProvider
implements CheckpointScheduling {
    private final ExecutionGraph executionGraph;

    CheckpointSchedulingProvider(ExecutionGraph executionGraph) {
        this.executionGraph = Preconditions.checkNotNull(executionGraph, "executionGraph must not be null");
    }

    @Override
    public void startCheckpointScheduler() {
        CheckpointCoordinator coordinator = this.executionGraph.getCheckpointCoordinator();
        if (coordinator == null) {
            Preconditions.checkState(this.executionGraph.getState().isTerminalState(), "CheckpointCoordinator is only allowed to be null if we are in a terminal state.");
            return;
        }
        if (coordinator.isPeriodicCheckpointingConfigured() && !coordinator.isPeriodicCheckpointingStarted()) {
            coordinator.startCheckpointScheduler();
        }
    }

    @Override
    public void stopCheckpointScheduler() {
        CheckpointCoordinator coordinator = this.executionGraph.getCheckpointCoordinator();
        if (coordinator != null) {
            coordinator.stopCheckpointScheduler();
        }
    }
}

