/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.ThrowingRunnable;

public class ComponentClosingUtils {
    private static Clock clock = SystemClock.getInstance();

    private ComponentClosingUtils() {
    }

    public static CompletableFuture<Void> closeAsyncWithTimeout(String componentName, Runnable closingSequence, Duration closeTimeout) {
        return ComponentClosingUtils.closeAsyncWithTimeout(componentName, closingSequence::run, closeTimeout);
    }

    public static CompletableFuture<Void> closeAsyncWithTimeout(String componentName, ThrowingRunnable<Exception> closingSequence, Duration closeTimeout) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Thread t = new Thread(() -> {
            try {
                closingSequence.run();
                future.complete(null);
            }
            catch (Throwable error) {
                future.completeExceptionally(error);
            }
        });
        t.start();
        future.exceptionally(error -> {
            if (error instanceof TimeoutException && t.isAlive()) {
                ComponentClosingUtils.abortThread(t);
            }
            return null;
        });
        FutureUtils.orTimeout(future, closeTimeout.toMillis(), TimeUnit.MILLISECONDS, String.format("Failed to close the %s before timeout of %d ms", componentName, closeTimeout.toMillis()));
        return future;
    }

    public static boolean tryShutdownExecutorElegantly(ExecutorService executor, Duration timeout) {
        try {
            executor.shutdown();
            executor.awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!executor.isTerminated()) {
            ComponentClosingUtils.shutdownExecutorForcefully(executor, Duration.ZERO, false);
        }
        return executor.isTerminated();
    }

    public static boolean shutdownExecutorForcefully(ExecutorService executor, Duration timeout) {
        return ComponentClosingUtils.shutdownExecutorForcefully(executor, timeout, true);
    }

    public static boolean shutdownExecutorForcefully(ExecutorService executor, Duration timeout, boolean interruptable) {
        Deadline deadline = Deadline.fromNowWithClock(timeout, clock);
        boolean isInterrupted = false;
        do {
            executor.shutdownNow();
            try {
                executor.awaitTermination(deadline.timeLeft().toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                isInterrupted = interruptable;
            }
        } while (!isInterrupted && deadline.hasTimeLeft() && !executor.isTerminated());
        return executor.isTerminated();
    }

    private static void abortThread(Thread t) {
        int i = 0;
        while (t.isAlive() && i < 10) {
            t.interrupt();
            ++i;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @VisibleForTesting
    static void setClock(Clock clock) {
        ComponentClosingUtils.clock = clock;
    }
}

