/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.chaining;

import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.metrics.groups.InternalOperatorIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.InternalOperatorMetricGroup;
import org.apache.flink.runtime.operators.BatchTask;
import org.apache.flink.runtime.operators.util.DistributedRuntimeUDFContext;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.operators.util.metrics.CountingCollector;
import org.apache.flink.util.Collector;
import org.apache.flink.util.UserCodeClassLoader;

public abstract class ChainedDriver<IT, OT>
implements Collector<IT> {
    protected TaskConfig config;
    protected String taskName;
    protected Collector<OT> outputCollector;
    protected ClassLoader userCodeClassLoader;
    private DistributedRuntimeUDFContext udfContext;
    protected ExecutionConfig executionConfig;
    protected boolean objectReuseEnabled = false;
    protected InternalOperatorMetricGroup metrics;
    protected Counter numRecordsIn;
    protected Counter numRecordsOut;

    public void setup(TaskConfig config, String taskName, Collector<OT> outputCollector, AbstractInvokable parent, UserCodeClassLoader userCodeClassLoader, ExecutionConfig executionConfig, Map<String, Accumulator<?, ?>> accumulatorMap) {
        this.config = config;
        this.taskName = taskName;
        this.userCodeClassLoader = userCodeClassLoader.asClassLoader();
        this.metrics = parent.getEnvironment().getMetricGroup().getOrAddOperator(taskName);
        this.numRecordsIn = this.metrics.getIOMetricGroup().getNumRecordsInCounter();
        this.numRecordsOut = this.metrics.getIOMetricGroup().getNumRecordsOutCounter();
        this.outputCollector = new CountingCollector<OT>(outputCollector, this.numRecordsOut);
        Environment env = parent.getEnvironment();
        this.udfContext = parent instanceof BatchTask ? ((BatchTask)parent).createRuntimeContext(this.metrics) : new DistributedRuntimeUDFContext(env.getTaskInfo(), userCodeClassLoader, parent.getExecutionConfig(), env.getDistributedCacheEntries(), accumulatorMap, this.metrics, env.getExternalResourceInfoProvider(), env.getJobID());
        this.executionConfig = executionConfig;
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        this.setup(parent);
    }

    public abstract void setup(AbstractInvokable var1);

    public abstract void openTask() throws Exception;

    public abstract void closeTask() throws Exception;

    public abstract void cancelTask();

    public abstract Function getStub();

    public abstract String getTaskName();

    @Override
    public abstract void collect(IT var1);

    public InternalOperatorIOMetricGroup getIOMetrics() {
        return this.metrics.getIOMetricGroup();
    }

    protected RuntimeContext getUdfRuntimeContext() {
        return this.udfContext;
    }

    public void setOutputCollector(Collector<?> outputCollector) {
        this.outputCollector = new CountingCollector(outputCollector, this.numRecordsOut);
    }

    public Collector<OT> getOutputCollector() {
        return this.outputCollector;
    }

    public TaskConfig getTaskConfig() {
        return this.config;
    }
}

