/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.time.Duration;
import java.util.Optional;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.executiongraph.failover.flip1.ExponentialDelayRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailureRateRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.FixedDelayRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.NoRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartBackoffTimeStrategy;
import org.apache.flink.util.Preconditions;

public final class RestartBackoffTimeStrategyFactoryLoader {
    static final int DEFAULT_RESTART_ATTEMPTS = Integer.MAX_VALUE;
    static final long DEFAULT_RESTART_DELAY = Duration.ofSeconds(1L).toMillis();

    private RestartBackoffTimeStrategyFactoryLoader() {
    }

    public static RestartBackoffTimeStrategy.Factory createRestartBackoffTimeStrategyFactory(RestartStrategies.RestartStrategyConfiguration jobRestartStrategyConfiguration, Configuration clusterConfiguration, boolean isCheckpointingEnabled) {
        Preconditions.checkNotNull(jobRestartStrategyConfiguration);
        Preconditions.checkNotNull(clusterConfiguration);
        return RestartBackoffTimeStrategyFactoryLoader.getJobRestartStrategyFactory(jobRestartStrategyConfiguration).orElse(RestartBackoffTimeStrategyFactoryLoader.getClusterRestartStrategyFactory(clusterConfiguration).orElse(RestartBackoffTimeStrategyFactoryLoader.getDefaultRestartStrategyFactory(isCheckpointingEnabled)));
    }

    private static Optional<RestartBackoffTimeStrategy.Factory> getJobRestartStrategyFactory(RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration) {
        if (restartStrategyConfiguration instanceof RestartStrategies.NoRestartStrategyConfiguration) {
            return Optional.of(NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.INSTANCE);
        }
        if (restartStrategyConfiguration instanceof RestartStrategies.FixedDelayRestartStrategyConfiguration) {
            RestartStrategies.FixedDelayRestartStrategyConfiguration fixedDelayConfig = (RestartStrategies.FixedDelayRestartStrategyConfiguration)restartStrategyConfiguration;
            return Optional.of(new FixedDelayRestartBackoffTimeStrategy.FixedDelayRestartBackoffTimeStrategyFactory(fixedDelayConfig.getRestartAttempts(), fixedDelayConfig.getDelayBetweenAttemptsInterval().toMilliseconds()));
        }
        if (restartStrategyConfiguration instanceof RestartStrategies.FailureRateRestartStrategyConfiguration) {
            RestartStrategies.FailureRateRestartStrategyConfiguration failureRateConfig = (RestartStrategies.FailureRateRestartStrategyConfiguration)restartStrategyConfiguration;
            return Optional.of(new FailureRateRestartBackoffTimeStrategy.FailureRateRestartBackoffTimeStrategyFactory(failureRateConfig.getMaxFailureRate(), failureRateConfig.getFailureInterval().toMilliseconds(), failureRateConfig.getDelayBetweenAttemptsInterval().toMilliseconds()));
        }
        if (restartStrategyConfiguration instanceof RestartStrategies.FallbackRestartStrategyConfiguration) {
            return Optional.empty();
        }
        if (restartStrategyConfiguration instanceof RestartStrategies.ExponentialDelayRestartStrategyConfiguration) {
            RestartStrategies.ExponentialDelayRestartStrategyConfiguration exponentialDelayConfig = (RestartStrategies.ExponentialDelayRestartStrategyConfiguration)restartStrategyConfiguration;
            return Optional.of(new ExponentialDelayRestartBackoffTimeStrategy.ExponentialDelayRestartBackoffTimeStrategyFactory(exponentialDelayConfig.getInitialBackoff().toMilliseconds(), exponentialDelayConfig.getMaxBackoff().toMilliseconds(), exponentialDelayConfig.getBackoffMultiplier(), exponentialDelayConfig.getResetBackoffThreshold().toMilliseconds(), exponentialDelayConfig.getJitterFactor()));
        }
        throw new IllegalArgumentException("Unknown restart strategy configuration " + restartStrategyConfiguration + ".");
    }

    private static Optional<RestartBackoffTimeStrategy.Factory> getClusterRestartStrategyFactory(Configuration clusterConfiguration) {
        String restartStrategyName = clusterConfiguration.getString(RestartStrategyOptions.RESTART_STRATEGY);
        if (restartStrategyName == null) {
            return Optional.empty();
        }
        switch (restartStrategyName.toLowerCase()) {
            case "none": 
            case "off": 
            case "disable": {
                return Optional.of(NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.INSTANCE);
            }
            case "fixeddelay": 
            case "fixed-delay": {
                return Optional.of(FixedDelayRestartBackoffTimeStrategy.createFactory(clusterConfiguration));
            }
            case "failurerate": 
            case "failure-rate": {
                return Optional.of(FailureRateRestartBackoffTimeStrategy.createFactory(clusterConfiguration));
            }
            case "exponentialdelay": 
            case "exponential-delay": {
                return Optional.of(ExponentialDelayRestartBackoffTimeStrategy.createFactory(clusterConfiguration));
            }
        }
        throw new IllegalArgumentException("Unknown restart strategy " + restartStrategyName + ".");
    }

    private static RestartBackoffTimeStrategy.Factory getDefaultRestartStrategyFactory(boolean isCheckpointingEnabled) {
        if (isCheckpointingEnabled) {
            return new FixedDelayRestartBackoffTimeStrategy.FixedDelayRestartBackoffTimeStrategyFactory(Integer.MAX_VALUE, DEFAULT_RESTART_DELAY);
        }
        return NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.INSTANCE;
    }
}

