/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.table.sink;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.base.sink.AsyncSinkBaseBuilder;
import org.apache.flink.table.connector.sink.DynamicTableSink;

@PublicEvolving
public abstract class AsyncDynamicTableSink<RequestEntryT extends Serializable>
implements DynamicTableSink {
    protected final Integer maxBatchSize;
    protected final Integer maxInFlightRequests;
    protected final Integer maxBufferedRequests;
    protected final Long maxBufferSizeInBytes;
    protected final Long maxTimeInBufferMS;

    protected AsyncDynamicTableSink(@Nullable Integer maxBatchSize, @Nullable Integer maxInFlightRequests, @Nullable Integer maxBufferedRequests, @Nullable Long maxBufferSizeInBytes, @Nullable Long maxTimeInBufferMS) {
        this.maxBatchSize = maxBatchSize;
        this.maxInFlightRequests = maxInFlightRequests;
        this.maxBufferedRequests = maxBufferedRequests;
        this.maxBufferSizeInBytes = maxBufferSizeInBytes;
        this.maxTimeInBufferMS = maxTimeInBufferMS;
    }

    public boolean equals(Object o) {
        AsyncDynamicTableSink that;
        if (this == o) {
            return true;
        }
        try {
            that = (AsyncDynamicTableSink)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        return Objects.equals(this.maxBatchSize, that.maxBatchSize) && Objects.equals(this.maxBufferedRequests, that.maxBufferedRequests) && Objects.equals(this.maxInFlightRequests, that.maxInFlightRequests) && Objects.equals(this.maxBufferSizeInBytes, that.maxBufferSizeInBytes) && Objects.equals(this.maxTimeInBufferMS, that.maxTimeInBufferMS);
    }

    public int hashCode() {
        return Objects.hash(this.maxBatchSize, this.maxBufferedRequests, this.maxInFlightRequests, this.maxBufferSizeInBytes, this.maxTimeInBufferMS);
    }

    protected AsyncSinkBaseBuilder<?, RequestEntryT, ?> addAsyncOptionsToSinkBuilder(AsyncSinkBaseBuilder<?, RequestEntryT, ?> builder) {
        Optional.ofNullable(this.maxBatchSize).ifPresent(builder::setMaxBatchSize);
        Optional.ofNullable(this.maxBufferSizeInBytes).ifPresent(builder::setMaxBatchSizeInBytes);
        Optional.ofNullable(this.maxInFlightRequests).ifPresent(builder::setMaxInFlightRequests);
        Optional.ofNullable(this.maxBufferedRequests).ifPresent(builder::setMaxBufferedRequests);
        Optional.ofNullable(this.maxTimeInBufferMS).ifPresent(builder::setMaxTimeInBufferMS);
        return builder;
    }
}

