/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.stats;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.stats.FieldStatsArraySerializer;
import org.apache.flink.table.store.file.utils.SerializationUtils;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.util.Preconditions;

public class BinaryTableStats {
    @Nullable
    private RowData row;
    @Nullable
    private FieldStats[] cacheArray;
    @Nullable
    private BinaryRowData cacheMin;
    @Nullable
    private BinaryRowData cacheMax;
    @Nullable
    private long[] cacheNullCounts;

    public BinaryTableStats(RowData row) {
        this.row = row;
    }

    public BinaryTableStats(BinaryRowData cacheMin, BinaryRowData cacheMax, long[] cacheNullCounts) {
        this(cacheMin, cacheMax, cacheNullCounts, null);
    }

    public BinaryTableStats(BinaryRowData cacheMin, BinaryRowData cacheMax, long[] cacheNullCounts, @Nullable FieldStats[] cacheArray) {
        this.cacheMin = cacheMin;
        this.cacheMax = cacheMax;
        this.cacheNullCounts = cacheNullCounts;
        this.cacheArray = cacheArray;
    }

    public FieldStats[] fields(FieldStatsArraySerializer converter) {
        return this.fields(converter, null);
    }

    public FieldStats[] fields(FieldStatsArraySerializer converter, @Nullable Long rowCount) {
        if (this.cacheArray == null) {
            this.cacheArray = converter.fromBinary(this, rowCount);
        }
        return this.cacheArray;
    }

    public BinaryRowData min() {
        if (this.cacheMin == null) {
            Preconditions.checkNotNull(this.row);
            this.cacheMin = SerializationUtils.deserializeBinaryRow(this.row.getBinary(0));
        }
        return this.cacheMin;
    }

    public BinaryRowData max() {
        if (this.cacheMax == null) {
            Preconditions.checkNotNull(this.row);
            this.cacheMax = SerializationUtils.deserializeBinaryRow(this.row.getBinary(1));
        }
        return this.cacheMax;
    }

    public long[] nullCounts() {
        if (this.cacheNullCounts == null) {
            Preconditions.checkNotNull(this.row);
            this.cacheNullCounts = this.row.getArray(2).toLongArray();
        }
        return this.cacheNullCounts;
    }

    public RowData toRowData() {
        return this.row == null ? GenericRowData.of(SerializationUtils.serializeBinaryRow(this.min()), SerializationUtils.serializeBinaryRow(this.max()), new GenericArrayData(this.nullCounts())) : this.row;
    }

    public static BinaryTableStats fromRowData(RowData row) {
        return new BinaryTableStats(row);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryTableStats that = (BinaryTableStats)o;
        return Objects.equals(this.min(), that.min()) && Objects.equals(this.max(), that.max()) && Arrays.equals(this.nullCounts(), that.nullCounts());
    }

    public int hashCode() {
        int result = Objects.hash(this.min(), this.max());
        result = 31 * result + Arrays.hashCode(this.nullCounts());
        return result;
    }
}

