/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.interval;

import org.apache.flink.api.common.functions.RichFlatJoinFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.NullAwareGetters;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.operators.join.NullAwareJoinHelper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;

public class IntervalJoinFunction
extends RichFlatJoinFunction<RowData, RowData, RowData>
implements ResultTypeQueryable<RowData> {
    private final InternalTypeInfo<RowData> returnTypeInfo;
    private final int[] nullFilterKeys;
    private final boolean nullSafe;
    private final boolean filterAllNulls;
    private GeneratedJoinCondition joinConditionCode;
    private transient JoinCondition joinCondition;
    private transient JoinedRowData reusedJoinRowData;
    private transient NullAwareGetters joinKey;

    public IntervalJoinFunction(GeneratedJoinCondition joinCondition, InternalTypeInfo<RowData> returnTypeInfo, boolean[] filterNulls) {
        this.joinConditionCode = joinCondition;
        this.returnTypeInfo = returnTypeInfo;
        this.nullFilterKeys = NullAwareJoinHelper.getNullFilterKeys(filterNulls);
        this.nullSafe = this.nullFilterKeys.length == 0;
        this.filterAllNulls = this.nullFilterKeys.length == filterNulls.length;
    }

    @Override
    public void open(Configuration config) throws Exception {
        this.joinCondition = (JoinCondition)this.joinConditionCode.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.joinConditionCode = null;
        this.joinCondition.setRuntimeContext(this.getRuntimeContext());
        this.joinCondition.open(config);
        this.reusedJoinRowData = new JoinedRowData();
    }

    @Override
    public void join(RowData first, RowData second, Collector<RowData> out) throws Exception {
        if (!this.nullSafe && (this.filterAllNulls ? this.joinKey.anyNull() : this.joinKey.anyNull(this.nullFilterKeys))) {
            return;
        }
        if (this.joinCondition.apply(first, second)) {
            out.collect(this.reusedJoinRowData.replace(first, second));
        }
    }

    @Override
    public TypeInformation<RowData> getProducedType() {
        return this.returnTypeInfo;
    }

    public void setJoinKey(RowData currentKey) {
        this.joinKey = (NullAwareGetters)((Object)currentKey);
    }
}

