/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class AggregatedTaskDetailsInfo
implements ResponseBody {
    public static final String FIELD_NAME_METRICS = "metrics";
    public static final String FIELD_NAME_STATUS_DURATION = "status-duration";
    private static final String[] metricsNames = new String[]{"read-bytes", "write-bytes", "read-records", "write-records", "accumulated-backpressured-time", "accumulated-busy-time", "accumulated-idle-time"};
    private static final String[] statusNames = new String[]{ExecutionState.CREATED.name(), ExecutionState.SCHEDULED.name(), ExecutionState.INITIALIZING.name(), ExecutionState.DEPLOYING.name(), ExecutionState.RUNNING.name()};
    @JsonProperty(value="metrics")
    private final Map<String, Map<String, Long>> metrics;
    @JsonProperty(value="status-duration")
    private final Map<String, Map<String, Long>> statusDuration;

    @JsonCreator
    public AggregatedTaskDetailsInfo(@JsonProperty(value="metrics") Map<String, Map<String, Long>> metrics, @JsonProperty(value="status-duration") Map<String, Map<String, Long>> statusDuration) {
        this.metrics = Preconditions.checkNotNull(metrics);
        this.statusDuration = Preconditions.checkNotNull(statusDuration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregatedTaskDetailsInfo that = (AggregatedTaskDetailsInfo)o;
        return Objects.equals(this.metrics, that.metrics) && Objects.equals(this.statusDuration, that.statusDuration);
    }

    public int hashCode() {
        return Objects.hash(this.metrics, this.statusDuration);
    }

    public static AggregatedTaskDetailsInfo create(List<SubtaskExecutionAttemptDetailsInfo> subtaskInfo) {
        return AggregatedTaskDetailsInfo.create(subtaskInfo.stream().map(SubtaskExecutionAttemptDetailsInfo::getIoMetricsInfo).collect(Collectors.toList()), subtaskInfo.stream().map(SubtaskExecutionAttemptDetailsInfo::getStatusDuration).collect(Collectors.toList()));
    }

    public static AggregatedTaskDetailsInfo create(List<IOMetricsInfo> ioMetricsInfos, List<Map<ExecutionState, Long>> statusDurations) {
        HashMap metrics = new HashMap();
        HashMap statusDuration = new HashMap();
        Arrays.stream(metricsNames).forEach(name -> metrics.put(name, new MetricsStatistics((String)name)));
        Arrays.stream(statusNames).forEach(name -> statusDuration.put(name, new MetricsStatistics((String)name)));
        ioMetricsInfos.forEach(ioMetricsInfo -> {
            ((MetricsStatistics)metrics.get("read-bytes")).addValue(ioMetricsInfo.getBytesRead());
            ((MetricsStatistics)metrics.get("write-bytes")).addValue(ioMetricsInfo.getBytesWritten());
            ((MetricsStatistics)metrics.get("read-records")).addValue(ioMetricsInfo.getRecordsRead());
            ((MetricsStatistics)metrics.get("write-records")).addValue(ioMetricsInfo.getRecordsWritten());
            ((MetricsStatistics)metrics.get("accumulated-idle-time")).addValue(ioMetricsInfo.getAccumulatedIdle());
            ((MetricsStatistics)metrics.get("accumulated-backpressured-time")).addValue(ioMetricsInfo.getAccumulatedBackpressured());
            if (!Double.isNaN(ioMetricsInfo.getAccumulatedBusy())) {
                ((MetricsStatistics)metrics.get("accumulated-busy-time")).addValue((long)ioMetricsInfo.getAccumulatedBusy());
            } else {
                ((MetricsStatistics)metrics.get("accumulated-busy-time")).addValue(-1L);
            }
        });
        statusDurations.forEach(status -> {
            ((MetricsStatistics)statusDuration.get(ExecutionState.CREATED.name())).addValue((Long)status.get((Object)ExecutionState.CREATED));
            ((MetricsStatistics)statusDuration.get(ExecutionState.SCHEDULED.name())).addValue((Long)status.get((Object)ExecutionState.SCHEDULED));
            ((MetricsStatistics)statusDuration.get(ExecutionState.INITIALIZING.name())).addValue((Long)status.get((Object)ExecutionState.INITIALIZING));
            ((MetricsStatistics)statusDuration.get(ExecutionState.DEPLOYING.name())).addValue((Long)status.get((Object)ExecutionState.DEPLOYING));
            ((MetricsStatistics)statusDuration.get(ExecutionState.RUNNING.name())).addValue((Long)status.get((Object)ExecutionState.RUNNING));
        });
        return new AggregatedTaskDetailsInfo(metrics.values().stream().collect(Collectors.toMap(rec$ -> ((MetricsStatistics)rec$).getName(), rec$ -> ((MetricsStatistics)rec$).toMap())), statusDuration.values().stream().collect(Collectors.toMap(rec$ -> ((MetricsStatistics)rec$).getName(), rec$ -> ((MetricsStatistics)rec$).toMap())));
    }

    @VisibleForTesting
    static class MetricsStatistics {
        private final List<Long> values = new ArrayList<Long>();
        private final String name;
        private long sum = 0L;
        private Percentile percentile = null;

        MetricsStatistics(String name) {
            this.name = name;
        }

        void addValue(long value) {
            this.values.add(value);
            this.sum += value;
        }

        private String getName() {
            return this.name;
        }

        private Map<String, Long> toMap() {
            HashMap<String, Long> result = new HashMap<String, Long>();
            result.put("min", this.getMin());
            result.put("max", this.getMax());
            result.put("avg", this.getAvg());
            result.put("sum", this.getSum());
            result.put("median", this.getPercentile(50));
            result.put("p25", this.getPercentile(25));
            result.put("p75", this.getPercentile(75));
            result.put("p95", this.getPercentile(95));
            return result;
        }

        long getMin() {
            return this.values.stream().reduce(BinaryOperator.minBy(Comparator.naturalOrder())).orElse(0L);
        }

        long getMax() {
            return this.values.stream().reduce(BinaryOperator.maxBy(Comparator.naturalOrder())).orElse(0L);
        }

        long getSum() {
            return this.sum;
        }

        long getAvg() {
            return this.values.isEmpty() ? 0L : this.sum / (long)this.values.size();
        }

        long getPercentile(int percent) {
            if (this.percentile == null) {
                this.percentile = new Percentile();
                this.percentile.setData(this.values.stream().mapToDouble(Long::doubleValue).toArray());
            }
            return (long)this.percentile.evaluate((double)percent);
        }
    }
}

