/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.reader.FileRecordFormat;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.connector.file.src.util.IteratorResultIterator;
import org.apache.flink.connector.file.src.util.Utils;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;

@Deprecated
@Internal
public final class FileRecordFormatAdapter<T>
implements BulkFormat<T, FileSourceSplit> {
    private static final long serialVersionUID = 1L;
    private final FileRecordFormat<T> fileFormat;

    public FileRecordFormatAdapter(FileRecordFormat<T> fileFormat) {
        this.fileFormat = Preconditions.checkNotNull(fileFormat);
    }

    @Override
    public BulkFormat.Reader<T> createReader(Configuration config, FileSourceSplit split) throws IOException {
        FileRecordFormat.Reader reader = this.fileFormat.createReader(config, split.path(), split.offset(), split.length());
        return Utils.doWithCleanupOnException(reader, () -> FileRecordFormatAdapter.wrapReader(reader, config, -1L, 0L));
    }

    @Override
    public BulkFormat.Reader<T> restoreReader(Configuration config, FileSourceSplit split) throws IOException {
        assert (split.getReaderPosition().isPresent());
        CheckpointedPosition checkpointedPosition = split.getReaderPosition().get();
        Path filePath = split.path();
        long splitOffset = split.offset();
        long splitLength = split.length();
        FileRecordFormat.Reader reader = checkpointedPosition.getOffset() == -1L ? this.fileFormat.createReader(config, filePath, splitOffset, splitLength) : this.fileFormat.restoreReader(config, filePath, checkpointedPosition.getOffset(), splitOffset, splitLength);
        return Utils.doWithCleanupOnException(reader, () -> {
            for (long remaining = checkpointedPosition.getRecordsAfterOffset(); remaining > 0L && reader.read() != null; --remaining) {
            }
            return FileRecordFormatAdapter.wrapReader(reader, config, checkpointedPosition.getOffset(), checkpointedPosition.getRecordsAfterOffset());
        });
    }

    @Override
    public boolean isSplittable() {
        return this.fileFormat.isSplittable();
    }

    @Override
    public TypeInformation<T> getProducedType() {
        return this.fileFormat.getProducedType();
    }

    private static <T> Reader<T> wrapReader(FileRecordFormat.Reader<T> reader, Configuration config, long startingOffset, long startingSkipCount) {
        int numRecordsPerBatch = config.get(FileRecordFormat.RECORDS_PER_FETCH);
        return new Reader<T>(reader, numRecordsPerBatch, startingOffset, startingSkipCount);
    }

    public static final class Reader<T>
    implements BulkFormat.Reader<T> {
        private final FileRecordFormat.Reader<T> reader;
        private final int numRecordsPerBatch;
        private long lastOffset;
        private long lastRecordsAfterOffset;

        Reader(FileRecordFormat.Reader<T> reader, int numRecordsPerBatch, long initialOffset, long initialSkipCount) {
            Preconditions.checkArgument(numRecordsPerBatch > 0, "numRecordsPerBatch must be > 0");
            this.reader = Preconditions.checkNotNull(reader);
            this.numRecordsPerBatch = numRecordsPerBatch;
            this.lastOffset = initialOffset;
            this.lastRecordsAfterOffset = initialSkipCount;
        }

        @Override
        @Nullable
        public BulkFormat.RecordIterator<T> readBatch() throws IOException {
            T next;
            this.updateCheckpointablePosition();
            ArrayList<T> result = new ArrayList<T>(this.numRecordsPerBatch);
            int remaining = this.numRecordsPerBatch;
            while (remaining-- > 0 && (next = this.reader.read()) != null) {
                result.add(next);
            }
            if (result.isEmpty()) {
                return null;
            }
            IteratorResultIterator iter = new IteratorResultIterator(result.iterator(), this.lastOffset, this.lastRecordsAfterOffset);
            this.lastRecordsAfterOffset += (long)result.size();
            return iter;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        private void updateCheckpointablePosition() {
            CheckpointedPosition position = this.reader.getCheckpointedPosition();
            if (position != null) {
                this.lastOffset = position.getOffset();
                this.lastRecordsAfterOffset = position.getRecordsAfterOffset();
            }
        }
    }
}

