/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.util.Preconditions;

@Internal
public final class AndArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final List<? extends ArgumentTypeStrategy> argumentStrategies;

    public AndArgumentTypeStrategy(List<? extends ArgumentTypeStrategy> argumentStrategies) {
        Preconditions.checkArgument(argumentStrategies.size() > 0);
        this.argumentStrategies = argumentStrategies;
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        DataType actualDataType = callContext.getArgumentDataTypes().get(argumentPos);
        LogicalType actualType = actualDataType.getLogicalType();
        Optional<DataType> closestDataType = Optional.empty();
        for (ArgumentTypeStrategy argumentTypeStrategy : this.argumentStrategies) {
            Optional<DataType> inferredDataType = argumentTypeStrategy.inferArgumentType(callContext, argumentPos, throwOnFailure);
            if (!inferredDataType.isPresent()) {
                return Optional.empty();
            }
            LogicalType inferredType = inferredDataType.get().getLogicalType();
            if (LogicalTypeCasts.supportsAvoidingCast(actualType, inferredType) || closestDataType.isPresent()) continue;
            closestDataType = inferredDataType;
        }
        if (closestDataType.isPresent()) {
            return closestDataType;
        }
        return Optional.of(actualDataType);
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        String argument = this.argumentStrategies.stream().map(v -> v.getExpectedArgument(functionDefinition, argumentPos).getType()).collect(Collectors.joining(" & ", "[", "]"));
        return Signature.Argument.of(argument);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndArgumentTypeStrategy that = (AndArgumentTypeStrategy)o;
        return Objects.equals(this.argumentStrategies, that.argumentStrategies);
    }

    public int hashCode() {
        return Objects.hash(this.argumentStrategies);
    }
}

