/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.append.AppendOnlyCompactManager;
import org.apache.flink.table.store.file.append.AppendOnlyWriter;
import org.apache.flink.table.store.file.compact.CompactManager;
import org.apache.flink.table.store.file.compact.NoopCompactManager;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.io.DataFilePathFactory;
import org.apache.flink.table.store.file.io.RowDataRollingFileWriter;
import org.apache.flink.table.store.file.operation.AbstractFileStoreWrite;
import org.apache.flink.table.store.file.operation.AppendOnlyFileStoreRead;
import org.apache.flink.table.store.file.operation.FileStoreScan;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.RecordReaderIterator;
import org.apache.flink.table.store.file.utils.RecordWriter;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.store.table.source.DataSplit;
import org.apache.flink.table.types.logical.RowType;

public class AppendOnlyFileStoreWrite
extends AbstractFileStoreWrite<RowData> {
    private final AppendOnlyFileStoreRead read;
    private final long schemaId;
    private final RowType rowType;
    private final FileFormat fileFormat;
    private final FileStorePathFactory pathFactory;
    private final long targetFileSize;
    private final int compactionMinFileNum;
    private final int compactionMaxFileNum;
    private final boolean commitForceCompact;
    private final boolean skipCompaction;

    public AppendOnlyFileStoreWrite(AppendOnlyFileStoreRead read, long schemaId, String commitUser, RowType rowType, FileStorePathFactory pathFactory, SnapshotManager snapshotManager, FileStoreScan scan, CoreOptions options) {
        super(commitUser, snapshotManager, scan);
        this.read = read;
        this.schemaId = schemaId;
        this.rowType = rowType;
        this.fileFormat = options.fileFormat();
        this.pathFactory = pathFactory;
        this.targetFileSize = options.targetFileSize();
        this.compactionMinFileNum = options.compactionMinFileNum();
        this.compactionMaxFileNum = options.compactionMaxFileNum();
        this.commitForceCompact = options.commitForceCompact();
        this.skipCompaction = options.writeOnly();
    }

    @Override
    public AbstractFileStoreWrite.WriterContainer<RowData> createWriterContainer(BinaryRowData partition, int bucket, ExecutorService compactExecutor) {
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        RecordWriter<RowData> writer = this.createWriter(partition, bucket, this.scanExistingFileMetas(latestSnapshotId, partition, bucket), compactExecutor);
        return new AbstractFileStoreWrite.WriterContainer<RowData>(writer, latestSnapshotId);
    }

    @Override
    public AbstractFileStoreWrite.WriterContainer<RowData> createEmptyWriterContainer(BinaryRowData partition, int bucket, ExecutorService compactExecutor) {
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        RecordWriter<RowData> writer = this.createWriter(partition, bucket, Collections.emptyList(), compactExecutor);
        return new AbstractFileStoreWrite.WriterContainer<RowData>(writer, latestSnapshotId);
    }

    private RecordWriter<RowData> createWriter(BinaryRowData partition, int bucket, List<DataFileMeta> restoredFiles, ExecutorService compactExecutor) {
        LinkedList<DataFileMeta> restored = new LinkedList<DataFileMeta>(restoredFiles);
        DataFilePathFactory factory = this.pathFactory.createDataFilePathFactory(partition, bucket);
        CompactManager compactManager = this.skipCompaction ? new NoopCompactManager() : new AppendOnlyCompactManager(compactExecutor, restored, this.compactionMinFileNum, this.compactionMaxFileNum, this.targetFileSize, this.compactRewriter(partition, bucket), factory);
        return new AppendOnlyWriter(this.schemaId, this.fileFormat, this.targetFileSize, this.rowType, DataFileMeta.getMaxSequenceNumber(restored), compactManager, this.commitForceCompact, factory);
    }

    private AppendOnlyCompactManager.CompactRewriter compactRewriter(BinaryRowData partition, int bucket) {
        return toCompact -> {
            if (toCompact.isEmpty()) {
                return Collections.emptyList();
            }
            RowDataRollingFileWriter rewriter = new RowDataRollingFileWriter(this.schemaId, this.fileFormat, this.targetFileSize, this.rowType, this.pathFactory.createDataFilePathFactory(partition, bucket), new LongCounter(((DataFileMeta)toCompact.get(0)).minSequenceNumber()));
            rewriter.write(new RecordReaderIterator<RowData>(this.read.createReader(new DataSplit(0L, partition, bucket, toCompact, false))));
            rewriter.close();
            return rewriter.result();
        };
    }
}

