/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerRegistration;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerSlot;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManagerId;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerInfo;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerTracker;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FineGrainedTaskManagerTracker
implements TaskManagerTracker {
    private static final Logger LOG = LoggerFactory.getLogger(FineGrainedTaskManagerTracker.class);
    private final Map<AllocationID, FineGrainedTaskManagerSlot> slots;
    private final Map<InstanceID, FineGrainedTaskManagerRegistration> taskManagerRegistrations;
    private final Map<PendingTaskManagerId, PendingTaskManager> pendingTaskManagers;
    private final Map<PendingTaskManagerId, Map<JobID, ResourceCounter>> pendingSlotAllocationRecords;
    private ResourceProfile totalRegisteredResource = ResourceProfile.ZERO;
    private ResourceProfile totalPendingResource = ResourceProfile.ZERO;
    private final Map<Tuple2<ResourceProfile, ResourceProfile>, Set<PendingTaskManager>> totalAndDefaultSlotProfilesToPendingTaskManagers;

    public FineGrainedTaskManagerTracker() {
        this.slots = new HashMap<AllocationID, FineGrainedTaskManagerSlot>();
        this.taskManagerRegistrations = new HashMap<InstanceID, FineGrainedTaskManagerRegistration>();
        this.pendingTaskManagers = new HashMap<PendingTaskManagerId, PendingTaskManager>();
        this.pendingSlotAllocationRecords = new HashMap<PendingTaskManagerId, Map<JobID, ResourceCounter>>();
        this.totalAndDefaultSlotProfilesToPendingTaskManagers = new HashMap<Tuple2<ResourceProfile, ResourceProfile>, Set<PendingTaskManager>>();
    }

    @Override
    public void replaceAllPendingAllocations(Map<PendingTaskManagerId, Map<JobID, ResourceCounter>> pendingSlotAllocations) {
        Preconditions.checkNotNull(pendingSlotAllocations);
        LOG.trace("Record the pending allocations {}.", pendingSlotAllocations);
        this.pendingSlotAllocationRecords.clear();
        this.pendingSlotAllocationRecords.putAll(pendingSlotAllocations);
    }

    @Override
    public void clearPendingAllocationsOfJob(JobID jobId) {
        LOG.info("Clear all pending allocations for job {}.", (Object)jobId);
        this.pendingSlotAllocationRecords.values().forEach(allocation -> {
            ResourceCounter cfr_ignored_0 = (ResourceCounter)allocation.remove(jobId);
        });
    }

    @Override
    public void addTaskManager(TaskExecutorConnection taskExecutorConnection, ResourceProfile totalResourceProfile, ResourceProfile defaultSlotResourceProfile) {
        Preconditions.checkNotNull(taskExecutorConnection);
        Preconditions.checkNotNull(totalResourceProfile);
        Preconditions.checkNotNull(defaultSlotResourceProfile);
        LOG.debug("Add task manager {} with total resource {} and default slot resource {}.", new Object[]{taskExecutorConnection.getInstanceID(), totalResourceProfile, defaultSlotResourceProfile});
        FineGrainedTaskManagerRegistration taskManagerRegistration = new FineGrainedTaskManagerRegistration(taskExecutorConnection, totalResourceProfile, defaultSlotResourceProfile);
        this.taskManagerRegistrations.put(taskExecutorConnection.getInstanceID(), taskManagerRegistration);
        this.totalRegisteredResource = this.totalRegisteredResource.merge(totalResourceProfile);
    }

    @Override
    public void removeTaskManager(InstanceID instanceId) {
        Preconditions.checkNotNull(instanceId);
        FineGrainedTaskManagerRegistration taskManager = Preconditions.checkNotNull(this.taskManagerRegistrations.remove(instanceId));
        this.totalRegisteredResource = this.totalRegisteredResource.subtract(taskManager.getTotalResource());
        LOG.debug("Remove task manager {}.", (Object)instanceId);
        for (AllocationID allocationId : taskManager.getAllocatedSlots().keySet()) {
            this.slots.remove(allocationId);
        }
    }

    @Override
    public void addPendingTaskManager(PendingTaskManager pendingTaskManager) {
        Preconditions.checkNotNull(pendingTaskManager);
        LOG.debug("Add pending task manager {}.", (Object)pendingTaskManager);
        this.pendingTaskManagers.put(pendingTaskManager.getPendingTaskManagerId(), pendingTaskManager);
        this.totalPendingResource = this.totalPendingResource.merge(pendingTaskManager.getTotalResourceProfile());
        this.totalAndDefaultSlotProfilesToPendingTaskManagers.computeIfAbsent(Tuple2.of(pendingTaskManager.getTotalResourceProfile(), pendingTaskManager.getDefaultSlotResourceProfile()), ignored -> new HashSet()).add(pendingTaskManager);
    }

    @Override
    public Map<JobID, ResourceCounter> removePendingTaskManager(PendingTaskManagerId pendingTaskManagerId) {
        Preconditions.checkNotNull(pendingTaskManagerId);
        PendingTaskManager pendingTaskManager = Preconditions.checkNotNull(this.pendingTaskManagers.remove(pendingTaskManagerId));
        this.totalPendingResource = this.totalPendingResource.subtract(pendingTaskManager.getTotalResourceProfile());
        LOG.debug("Remove pending task manager {}.", (Object)pendingTaskManagerId);
        this.totalAndDefaultSlotProfilesToPendingTaskManagers.compute(Tuple2.of(pendingTaskManager.getTotalResourceProfile(), pendingTaskManager.getDefaultSlotResourceProfile()), (ignored, pendingTMSet) -> {
            Preconditions.checkNotNull(pendingTMSet).remove(pendingTaskManager);
            return pendingTMSet.isEmpty() ? null : pendingTMSet;
        });
        return Optional.ofNullable(this.pendingSlotAllocationRecords.remove(pendingTaskManagerId)).orElse(Collections.emptyMap());
    }

    @Override
    public void notifySlotStatus(AllocationID allocationId, JobID jobId, InstanceID instanceId, ResourceProfile resourceProfile, SlotState slotState) {
        Preconditions.checkNotNull(allocationId);
        Preconditions.checkNotNull(jobId);
        Preconditions.checkNotNull(instanceId);
        Preconditions.checkNotNull(resourceProfile);
        Preconditions.checkNotNull(slotState);
        switch (slotState) {
            case FREE: {
                this.freeSlot(instanceId, allocationId);
                break;
            }
            case ALLOCATED: {
                this.addAllocatedSlot(allocationId, jobId, instanceId, resourceProfile);
                break;
            }
            case PENDING: {
                this.addPendingSlot(allocationId, jobId, instanceId, resourceProfile);
            }
        }
    }

    private void freeSlot(InstanceID instanceId, AllocationID allocationId) {
        FineGrainedTaskManagerRegistration taskManager = Preconditions.checkNotNull(this.taskManagerRegistrations.get(instanceId));
        Preconditions.checkNotNull(this.slots.remove(allocationId));
        LOG.debug("Free allocated slot with allocationId {}.", (Object)allocationId);
        taskManager.freeSlot(allocationId);
    }

    private void addAllocatedSlot(AllocationID allocationId, JobID jobId, InstanceID instanceId, ResourceProfile resourceProfile) {
        FineGrainedTaskManagerRegistration taskManager = Preconditions.checkNotNull(this.taskManagerRegistrations.get(instanceId));
        if (this.slots.containsKey(allocationId)) {
            LOG.debug("Complete slot allocation with allocationId {}.", (Object)allocationId);
            taskManager.notifyAllocationComplete(allocationId);
        } else {
            LOG.debug("Register new allocated slot with allocationId {}.", (Object)allocationId);
            FineGrainedTaskManagerSlot slot = new FineGrainedTaskManagerSlot(allocationId, jobId, resourceProfile, taskManager.getTaskExecutorConnection(), SlotState.ALLOCATED);
            this.slots.put(allocationId, slot);
            taskManager.notifyAllocation(allocationId, slot);
        }
    }

    private void addPendingSlot(AllocationID allocationId, JobID jobId, InstanceID instanceId, ResourceProfile resourceProfile) {
        Preconditions.checkState(!this.slots.containsKey(allocationId));
        FineGrainedTaskManagerRegistration taskManager = Preconditions.checkNotNull(this.taskManagerRegistrations.get(instanceId));
        LOG.debug("Add pending slot with allocationId {}.", (Object)allocationId);
        FineGrainedTaskManagerSlot slot = new FineGrainedTaskManagerSlot(allocationId, jobId, resourceProfile, taskManager.getTaskExecutorConnection(), SlotState.PENDING);
        taskManager.notifyAllocation(allocationId, slot);
        this.slots.put(allocationId, slot);
    }

    @Override
    public Map<JobID, ResourceCounter> getPendingAllocationsOfPendingTaskManager(PendingTaskManagerId pendingTaskManagerId) {
        return Collections.unmodifiableMap(this.pendingSlotAllocationRecords.getOrDefault(pendingTaskManagerId, Collections.emptyMap()));
    }

    @Override
    public Collection<? extends TaskManagerInfo> getRegisteredTaskManagers() {
        return Collections.unmodifiableCollection(this.taskManagerRegistrations.values());
    }

    @Override
    public Optional<TaskManagerInfo> getRegisteredTaskManager(InstanceID instanceId) {
        return Optional.ofNullable(this.taskManagerRegistrations.get(instanceId));
    }

    @Override
    public Optional<TaskManagerSlotInformation> getAllocatedOrPendingSlot(AllocationID allocationId) {
        return Optional.ofNullable(this.slots.get(allocationId));
    }

    @Override
    public Collection<PendingTaskManager> getPendingTaskManagers() {
        return Collections.unmodifiableCollection(this.pendingTaskManagers.values());
    }

    @Override
    public Collection<PendingTaskManager> getPendingTaskManagersByTotalAndDefaultSlotResourceProfile(ResourceProfile totalResourceProfile, ResourceProfile defaultSlotResourceProfile) {
        return Collections.unmodifiableCollection(this.totalAndDefaultSlotProfilesToPendingTaskManagers.getOrDefault(Tuple2.of(totalResourceProfile, defaultSlotResourceProfile), Collections.emptySet()));
    }

    @Override
    public int getNumberRegisteredSlots() {
        return this.taskManagerRegistrations.values().stream().mapToInt(TaskManagerInfo::getDefaultNumSlots).sum();
    }

    @Override
    public int getNumberRegisteredSlotsOf(InstanceID instanceId) {
        return Optional.ofNullable(this.taskManagerRegistrations.get(instanceId)).map(TaskManagerInfo::getDefaultNumSlots).orElse(0);
    }

    @Override
    public int getNumberFreeSlots() {
        return this.taskManagerRegistrations.keySet().stream().mapToInt(this::getNumberFreeSlotsOf).sum();
    }

    @Override
    public int getNumberFreeSlotsOf(InstanceID instanceId) {
        return Optional.ofNullable(this.taskManagerRegistrations.get(instanceId)).map(taskManager -> Math.max(taskManager.getDefaultNumSlots() - taskManager.getAllocatedSlots().size(), 0)).orElse(0);
    }

    @Override
    public ResourceProfile getRegisteredResource() {
        return this.totalRegisteredResource;
    }

    @Override
    public ResourceProfile getRegisteredResourceOf(InstanceID instanceId) {
        return Optional.ofNullable(this.taskManagerRegistrations.get(instanceId)).map(TaskManagerInfo::getTotalResource).orElse(ResourceProfile.ZERO);
    }

    @Override
    public ResourceProfile getFreeResource() {
        return this.taskManagerRegistrations.values().stream().map(TaskManagerInfo::getAvailableResource).reduce(ResourceProfile.ZERO, ResourceProfile::merge);
    }

    @Override
    public ResourceProfile getFreeResourceOf(InstanceID instanceId) {
        return Optional.ofNullable(this.taskManagerRegistrations.get(instanceId)).map(TaskManagerInfo::getAvailableResource).orElse(ResourceProfile.ZERO);
    }

    @Override
    public ResourceProfile getPendingResource() {
        return this.totalPendingResource;
    }

    @Override
    public void clear() {
        this.slots.clear();
        this.taskManagerRegistrations.clear();
        this.totalRegisteredResource = ResourceProfile.ZERO;
        this.pendingTaskManagers.clear();
        this.totalPendingResource = ResourceProfile.ZERO;
        this.pendingSlotAllocationRecords.clear();
    }
}

