/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.dispatcher.JobManagerRunnerRegistry;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.util.WrappingProxy;

public class OnMainThreadJobManagerRunnerRegistry
implements JobManagerRunnerRegistry,
WrappingProxy<JobManagerRunnerRegistry> {
    private final JobManagerRunnerRegistry delegate;
    private final ComponentMainThreadExecutor mainThreadExecutor;

    public OnMainThreadJobManagerRunnerRegistry(JobManagerRunnerRegistry delegate, ComponentMainThreadExecutor mainThreadExecutor) {
        this.delegate = delegate;
        this.mainThreadExecutor = mainThreadExecutor;
    }

    @Override
    public boolean isRegistered(JobID jobId) {
        this.mainThreadExecutor.assertRunningInMainThread();
        return this.delegate.isRegistered(jobId);
    }

    @Override
    public void register(JobManagerRunner jobManagerRunner) {
        this.mainThreadExecutor.assertRunningInMainThread();
        this.delegate.register(jobManagerRunner);
    }

    @Override
    public JobManagerRunner get(JobID jobId) {
        this.mainThreadExecutor.assertRunningInMainThread();
        return this.delegate.get(jobId);
    }

    @Override
    public int size() {
        this.mainThreadExecutor.assertRunningInMainThread();
        return this.delegate.size();
    }

    @Override
    public Set<JobID> getRunningJobIds() {
        this.mainThreadExecutor.assertRunningInMainThread();
        return this.delegate.getRunningJobIds();
    }

    @Override
    public Collection<JobManagerRunner> getJobManagerRunners() {
        this.mainThreadExecutor.assertRunningInMainThread();
        return this.delegate.getJobManagerRunners();
    }

    @Override
    public CompletableFuture<Void> localCleanupAsync(JobID jobId, Executor executor) {
        this.mainThreadExecutor.assertRunningInMainThread();
        return this.delegate.localCleanupAsync(jobId, executor);
    }

    @Override
    public JobManagerRunner unregister(JobID jobId) {
        this.mainThreadExecutor.assertRunningInMainThread();
        return this.delegate.unregister(jobId);
    }

    @Override
    public JobManagerRunnerRegistry getWrappedDelegate() {
        return this.delegate;
    }
}

