/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.mapred;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.RowDataContainer;
import org.apache.flink.table.store.file.utils.RecordReaderIterator;
import org.apache.flink.table.store.mapred.TableStoreInputSplit;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.flink.table.store.utils.ProjectedRowData;
import org.apache.hadoop.mapred.RecordReader;

public class TableStoreRecordReader
implements RecordReader<Void, RowDataContainer> {
    private final RecordReaderIterator<RowData> iterator;
    private final long splitLength;
    @Nullable
    private final ProjectedRowData reusedProjectedRow;
    private float progress;

    public TableStoreRecordReader(TableRead read, TableStoreInputSplit split, List<String> columnNames, List<String> selectedColumns) throws IOException {
        if (columnNames.equals(selectedColumns)) {
            this.reusedProjectedRow = null;
        } else {
            read.withProjection(selectedColumns.stream().mapToInt(columnNames::indexOf).toArray());
            this.reusedProjectedRow = ProjectedRowData.from(columnNames.stream().mapToInt(selectedColumns::indexOf).toArray());
        }
        this.iterator = new RecordReaderIterator<RowData>(read.createReader(split.split()));
        this.splitLength = split.getLength();
        this.progress = 0.0f;
    }

    public boolean next(Void key, RowDataContainer value) throws IOException {
        RowData rowData = this.iterator.next();
        if (rowData == null) {
            this.progress = 1.0f;
            return false;
        }
        if (this.reusedProjectedRow != null) {
            value.set(this.reusedProjectedRow.replaceRow(rowData));
        } else {
            value.set(rowData);
        }
        return true;
    }

    public Void createKey() {
        return null;
    }

    public RowDataContainer createValue() {
        return new RowDataContainer();
    }

    public long getPos() throws IOException {
        return (long)((float)this.splitLength * this.getProgress());
    }

    public void close() throws IOException {
        try {
            this.iterator.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public float getProgress() throws IOException {
        return this.progress;
    }
}

