/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.table.source.DataSplit;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;

public class TableStoreInputSplit
extends FileSplit {
    private static final String[] ANYWHERE = new String[]{"*"};
    private String path;
    private DataSplit split;

    public TableStoreInputSplit() {
    }

    public TableStoreInputSplit(String path, DataSplit split) {
        this.path = path;
        this.split = split;
    }

    public DataSplit split() {
        return this.split;
    }

    public Path getPath() {
        return new Path(this.path);
    }

    public long getStart() {
        return 0L;
    }

    public long getLength() {
        return this.split.files().stream().mapToLong(DataFileMeta::fileSize).sum();
    }

    public String[] getLocations() {
        return ANYWHERE;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.path);
        DataOutputSerializer out = new DataOutputSerializer(128);
        this.split.serialize(out);
        dataOutput.writeInt(out.length());
        dataOutput.write(out.getCopyOfBuffer());
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.path = dataInput.readUTF();
        int length = dataInput.readInt();
        byte[] bytes = new byte[length];
        dataInput.readFully(bytes);
        this.split = DataSplit.deserialize(new DataInputDeserializer(bytes));
    }

    public String toString() {
        return "{path='" + this.path + '\'' + ", split=" + this.split + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TableStoreInputSplit that = (TableStoreInputSplit)((Object)o);
        return Objects.equals(this.path, that.path) && Objects.equals(this.split, that.split);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.split);
    }
}

