/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.mapred;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.RowDataContainer;
import org.apache.flink.table.store.SearchArgumentToPredicateConverter;
import org.apache.flink.table.store.TableStoreJobConf;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.filesystem.FileSystems;
import org.apache.flink.table.store.mapred.TableStoreInputSplit;
import org.apache.flink.table.store.mapred.TableStoreRecordReader;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.FileStoreTableFactory;
import org.apache.flink.table.store.table.source.DataSplit;
import org.apache.flink.table.store.table.source.DataTableScan;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class TableStoreInputFormat
implements InputFormat<Void, RowDataContainer> {
    public InputSplit[] getSplits(JobConf jobConf, int numSplits) {
        FileStoreTable table = this.createFileStoreTable(jobConf);
        DataTableScan scan = table.newScan();
        this.createPredicate(table.schema(), jobConf).ifPresent(scan::withFilter);
        return (InputSplit[])scan.plan().splits.stream().map(split -> new TableStoreInputSplit(table.location().toString(), (DataSplit)split)).toArray(TableStoreInputSplit[]::new);
    }

    public RecordReader<Void, RowDataContainer> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
        FileStoreTable table = this.createFileStoreTable(jobConf);
        TableStoreInputSplit split = (TableStoreInputSplit)inputSplit;
        TableRead read = table.newRead();
        this.createPredicate(table.schema(), jobConf).ifPresent(read::withFilter);
        return new TableStoreRecordReader(read, split, table.schema().fieldNames(), Arrays.asList(this.getSelectedColumns(jobConf)));
    }

    private FileStoreTable createFileStoreTable(JobConf jobConf) {
        TableStoreJobConf wrapper = new TableStoreJobConf(jobConf);
        Configuration conf = new Configuration();
        conf.set((ConfigOption)CoreOptions.PATH, wrapper.getLocation());
        FileSystems.initialize(new Path(wrapper.getLocation()), wrapper.getCatalogConfig());
        return FileStoreTableFactory.create(conf);
    }

    private Optional<Predicate> createPredicate(TableSchema tableSchema, JobConf jobConf) {
        SearchArgument sarg = ConvertAstToSearchArg.createFromConf((org.apache.hadoop.conf.Configuration)jobConf);
        if (sarg == null) {
            return Optional.empty();
        }
        SearchArgumentToPredicateConverter converter = new SearchArgumentToPredicateConverter(sarg, tableSchema.fieldNames(), tableSchema.logicalRowType().getChildren());
        return converter.convert();
    }

    private String[] getSelectedColumns(JobConf jobConf) {
        return (String[])Arrays.stream(ColumnProjectionUtils.getReadColumnNames((org.apache.hadoop.conf.Configuration)jobConf)).distinct().toArray(String[]::new);
    }
}

