/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format.parquet;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.table.store.format.FileStatsExtractor;
import org.apache.flink.table.store.format.parquet.ParquetUtil;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.IntStatistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.LongStatistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.flink.table.store.utils.DateTimeUtils;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

public class ParquetFileStatsExtractor
implements FileStatsExtractor {
    private final RowType rowType;
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    public ParquetFileStatsExtractor(RowType rowType) {
        this.rowType = rowType;
    }

    @Override
    public FieldStats[] extract(Path path) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = new org.apache.hadoop.fs.Path(path.toUri());
        Map<String, Statistics> stats = ParquetUtil.extractColumnStats(hadoopPath);
        return (FieldStats[])IntStream.range(0, this.rowType.getFieldCount()).mapToObj(i -> {
            RowType.RowField field = this.rowType.getFields().get(i);
            return this.toFieldStats(field, (Statistics)stats.get(field.getName()));
        }).toArray(FieldStats[]::new);
    }

    private FieldStats toFieldStats(RowType.RowField field, Statistics stats) {
        LogicalTypeRoot flinkType = field.getType().getTypeRoot();
        if (stats == null || flinkType == LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE || flinkType == LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) {
            throw new UnsupportedOperationException("type " + (Object)((Object)field.getType().getTypeRoot()) + " not supported for extracting statistics in parquet format");
        }
        long nullCount = stats.getNumNulls();
        if (!stats.hasNonNullValue()) {
            return new FieldStats(null, null, nullCount);
        }
        switch (flinkType) {
            case CHAR: 
            case VARCHAR: {
                ParquetUtil.assertStatsClass(field, stats, BinaryStatistics.class);
                BinaryStatistics binaryStats = (BinaryStatistics)stats;
                return new FieldStats(StringData.fromString(binaryStats.minAsString()), StringData.fromString(binaryStats.maxAsString()), nullCount);
            }
            case BOOLEAN: {
                ParquetUtil.assertStatsClass(field, stats, BooleanStatistics.class);
                BooleanStatistics boolStats = (BooleanStatistics)stats;
                return new FieldStats(boolStats.getMin(), boolStats.getMax(), nullCount);
            }
            case DECIMAL: {
                PrimitiveType primitive = stats.type();
                DecimalType decimalType = (DecimalType)field.getType();
                int precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (primitive.getOriginalType() != null && primitive.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    return this.convertStatsToDecimalFieldStats(primitive, field, stats, precision, scale, nullCount);
                }
                return new FieldStats(null, null, nullCount);
            }
            case TINYINT: {
                ParquetUtil.assertStatsClass(field, stats, IntStatistics.class);
                IntStatistics byteStats = (IntStatistics)stats;
                return new FieldStats((byte)byteStats.getMin(), (byte)byteStats.getMax(), nullCount);
            }
            case SMALLINT: {
                ParquetUtil.assertStatsClass(field, stats, IntStatistics.class);
                IntStatistics shortStats = (IntStatistics)stats;
                return new FieldStats((short)shortStats.getMin(), (short)shortStats.getMax(), nullCount);
            }
            case INTEGER: {
                ParquetUtil.assertStatsClass(field, stats, IntStatistics.class);
                IntStatistics intStats = (IntStatistics)stats;
                return new FieldStats(Long.valueOf(intStats.getMin()).intValue(), Long.valueOf(intStats.getMax()).intValue(), nullCount);
            }
            case BIGINT: {
                ParquetUtil.assertStatsClass(field, stats, LongStatistics.class);
                LongStatistics longStats = (LongStatistics)stats;
                return new FieldStats(longStats.getMin(), longStats.getMax(), nullCount);
            }
            case FLOAT: {
                ParquetUtil.assertStatsClass(field, stats, FloatStatistics.class);
                FloatStatistics floatStats = (FloatStatistics)stats;
                return new FieldStats(Float.valueOf(floatStats.getMin()), Float.valueOf(floatStats.getMax()), nullCount);
            }
            case DOUBLE: {
                ParquetUtil.assertStatsClass(field, stats, DoubleStatistics.class);
                DoubleStatistics doubleStats = (DoubleStatistics)stats;
                return new FieldStats(doubleStats.getMin(), doubleStats.getMax(), nullCount);
            }
            case DATE: {
                ParquetUtil.assertStatsClass(field, stats, IntStatistics.class);
                IntStatistics dateStats = (IntStatistics)stats;
                return new FieldStats(DateTimeUtils.toInternal(EPOCH_DAY.plusDays(dateStats.getMin())), DateTimeUtils.toInternal(EPOCH_DAY.plusDays(dateStats.getMax())), nullCount);
            }
        }
        return new FieldStats(null, null, nullCount);
    }

    private FieldStats convertStatsToDecimalFieldStats(PrimitiveType primitive, RowType.RowField field, Statistics stats, int precision, int scale, long nullCount) {
        switch (primitive.getPrimitiveTypeName()) {
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                ParquetUtil.assertStatsClass(field, stats, BinaryStatistics.class);
                BinaryStatistics decimalStats = (BinaryStatistics)stats;
                return new FieldStats(DecimalData.fromBigDecimal(new BigDecimal(new BigInteger(decimalStats.getMinBytes()), scale), precision, scale), DecimalData.fromBigDecimal(new BigDecimal(new BigInteger(decimalStats.getMaxBytes()), scale), precision, scale), nullCount);
            }
            case INT64: {
                ParquetUtil.assertStatsClass(field, stats, LongStatistics.class);
                LongStatistics longStats = (LongStatistics)stats;
                return new FieldStats(DecimalData.fromUnscaledLong(longStats.getMin(), precision, scale), DecimalData.fromUnscaledLong(longStats.getMax(), precision, scale), nullCount);
            }
            case INT32: {
                ParquetUtil.assertStatsClass(field, stats, IntStatistics.class);
                IntStatistics intStats = (IntStatistics)stats;
                return new FieldStats(DecimalData.fromUnscaledLong(intStats.getMin(), precision, scale), DecimalData.fromUnscaledLong(intStats.getMax(), precision, scale), nullCount);
            }
        }
        return new FieldStats(null, null, nullCount);
    }
}

