/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.io.StatsCollectingSingleFileWriter;
import org.apache.flink.table.store.file.stats.BinaryTableStats;
import org.apache.flink.table.store.file.stats.FieldStatsArraySerializer;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.table.store.format.FileStatsExtractor;
import org.apache.flink.table.types.logical.RowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueDataFileWriter
extends StatsCollectingSingleFileWriter<KeyValue, DataFileMeta> {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueDataFileWriter.class);
    private final RowType keyType;
    private final RowType valueType;
    private final long schemaId;
    private final int level;
    private final FieldStatsArraySerializer keyStatsConverter;
    private final FieldStatsArraySerializer valueStatsConverter;
    private final RowDataSerializer keySerializer;
    private BinaryRowData minKey = null;
    private RowData maxKey = null;
    private long minSeqNumber = Long.MAX_VALUE;
    private long maxSeqNumber = Long.MIN_VALUE;

    public KeyValueDataFileWriter(BulkWriter.Factory<RowData> factory, Path path, Function<KeyValue, RowData> converter, RowType keyType, RowType valueType, @Nullable FileStatsExtractor fileStatsExtractor, long schemaId, int level) {
        super(factory, path, converter, KeyValue.schema(keyType, valueType), fileStatsExtractor);
        this.keyType = keyType;
        this.valueType = valueType;
        this.schemaId = schemaId;
        this.level = level;
        this.keyStatsConverter = new FieldStatsArraySerializer(keyType);
        this.valueStatsConverter = new FieldStatsArraySerializer(valueType);
        this.keySerializer = new RowDataSerializer(keyType);
    }

    @Override
    public void write(KeyValue kv) throws IOException {
        super.write(kv);
        this.updateMinKey(kv);
        this.updateMaxKey(kv);
        this.updateMinSeqNumber(kv);
        this.updateMaxSeqNumber(kv);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Write key value " + kv.toString(this.keyType, this.valueType));
        }
    }

    private void updateMinKey(KeyValue kv) {
        if (this.minKey == null) {
            this.minKey = this.keySerializer.toBinaryRow(kv.key()).copy();
        }
    }

    private void updateMaxKey(KeyValue kv) {
        this.maxKey = kv.key();
    }

    private void updateMinSeqNumber(KeyValue kv) {
        this.minSeqNumber = Math.min(this.minSeqNumber, kv.sequenceNumber());
    }

    private void updateMaxSeqNumber(KeyValue kv) {
        this.maxSeqNumber = Math.max(this.maxSeqNumber, kv.sequenceNumber());
    }

    @Override
    @Nullable
    public DataFileMeta result() throws IOException {
        if (this.recordCount() == 0L) {
            return null;
        }
        FieldStats[] rowStats = this.fieldStats();
        int numKeyFields = this.keyType.getFieldCount();
        FieldStats[] keyFieldStats = Arrays.copyOfRange(rowStats, 0, numKeyFields);
        BinaryTableStats keyStats = this.keyStatsConverter.toBinary(keyFieldStats);
        FieldStats[] valFieldStats = Arrays.copyOfRange(rowStats, numKeyFields + 2, rowStats.length);
        BinaryTableStats valueStats = this.valueStatsConverter.toBinary(valFieldStats);
        return new DataFileMeta(this.path.getName(), FileUtils.getFileSize(this.path), this.recordCount(), this.minKey, this.keySerializer.toBinaryRow(this.maxKey).copy(), keyStats, valueStats, this.minSeqNumber, this.maxSeqNumber, this.schemaId, this.level);
    }
}

