/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.runtime.typeutils.DecimalDataSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeQueryable;

@Internal
public class DecimalDataTypeInfo
extends TypeInformation<DecimalData>
implements DataTypeQueryable {
    private static final long serialVersionUID = 1L;
    private final int precision;
    private final int scale;

    public static DecimalDataTypeInfo of(int precision, int scale) {
        return new DecimalDataTypeInfo(precision, scale);
    }

    public DecimalDataTypeInfo(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public DataType getDataType() {
        return (DataType)DataTypes.DECIMAL(this.precision, this.scale).bridgedTo(DecimalData.class);
    }

    @Override
    public boolean isBasicType() {
        return true;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<DecimalData> getTypeClass() {
        return DecimalData.class;
    }

    @Override
    public boolean isKeyType() {
        return true;
    }

    @Override
    public TypeSerializer<DecimalData> createSerializer(ExecutionConfig config) {
        return new DecimalDataSerializer(this.precision, this.scale);
    }

    @Override
    public String toString() {
        return String.format("Decimal(%d,%d)", this.precision, this.scale);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DecimalDataTypeInfo)) {
            return false;
        }
        DecimalDataTypeInfo that = (DecimalDataTypeInfo)obj;
        return this.precision == that.precision && this.scale == that.scale;
    }

    @Override
    public int hashCode() {
        int h0 = this.getClass().getCanonicalName().hashCode();
        return Arrays.hashCode(new int[]{h0, this.precision, this.scale});
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof DecimalDataTypeInfo;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }
}

