/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink.committables;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.streaming.runtime.operators.sink.committables.CommitRequestState;

@Internal
public class CommitRequestImpl<CommT>
implements Committer.CommitRequest<CommT> {
    private CommT committable;
    private int numRetries;
    private CommitRequestState state;

    protected CommitRequestImpl(CommT committable) {
        this.committable = committable;
        this.state = CommitRequestState.RECEIVED;
    }

    protected CommitRequestImpl(CommT committable, int numRetries, CommitRequestState state) {
        this.committable = committable;
        this.numRetries = numRetries;
        this.state = state;
    }

    boolean isFinished() {
        return this.state.isFinalState();
    }

    CommitRequestState getState() {
        return this.state;
    }

    @Override
    public CommT getCommittable() {
        return this.committable;
    }

    @Override
    public int getNumberOfRetries() {
        return this.numRetries;
    }

    @Override
    public void signalFailedWithKnownReason(Throwable t) {
        this.state = CommitRequestState.FAILED;
    }

    @Override
    public void signalFailedWithUnknownReason(Throwable t) {
        this.state = CommitRequestState.FAILED;
        throw new IllegalStateException("Failed to commit " + this.committable, t);
    }

    @Override
    public void retryLater() {
        this.state = CommitRequestState.RETRY;
        ++this.numRetries;
    }

    @Override
    public void updateAndRetryLater(CommT committable) {
        this.committable = committable;
        this.retryLater();
    }

    @Override
    public void signalAlreadyCommitted() {
        this.state = CommitRequestState.COMMITTED;
    }

    void setSelected() {
        this.state = CommitRequestState.RECEIVED;
    }

    void setCommittedIfNoError() {
        if (this.state == CommitRequestState.RECEIVED) {
            this.state = CommitRequestState.COMMITTED;
        }
    }

    CommitRequestImpl<CommT> copy() {
        return new CommitRequestImpl<CommT>(this.committable, this.numRetries, this.state);
    }
}

