/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.datastream.WindowedStream;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

@Public
public class CoGroupedStreams<T1, T2> {
    private final DataStream<T1> input1;
    private final DataStream<T2> input2;

    public CoGroupedStreams(DataStream<T1> input1, DataStream<T2> input2) {
        this.input1 = Objects.requireNonNull(input1);
        this.input2 = Objects.requireNonNull(input2);
    }

    public <KEY> Where<KEY> where(KeySelector<T1, KEY> keySelector) {
        Preconditions.checkNotNull(keySelector);
        TypeInformation<KEY> keyType = TypeExtractor.getKeySelectorTypes(keySelector, this.input1.getType());
        return this.where(keySelector, keyType);
    }

    public <KEY> Where<KEY> where(KeySelector<T1, KEY> keySelector, TypeInformation<KEY> keyType) {
        Preconditions.checkNotNull(keySelector);
        Preconditions.checkNotNull(keyType);
        return new Where<KEY>(this.input1.clean(keySelector), keyType);
    }

    private static class CoGroupWindowFunction<T1, T2, T, KEY, W extends Window>
    extends WrappingFunction<CoGroupFunction<T1, T2, T>>
    implements WindowFunction<TaggedUnion<T1, T2>, T, KEY, W> {
        private static final long serialVersionUID = 1L;

        public CoGroupWindowFunction(CoGroupFunction<T1, T2, T> userFunction) {
            super(userFunction);
        }

        @Override
        public void apply(KEY key, W window, Iterable<TaggedUnion<T1, T2>> values, Collector<T> out) throws Exception {
            ArrayList<T1> oneValues = new ArrayList<T1>();
            ArrayList<T2> twoValues = new ArrayList<T2>();
            for (TaggedUnion<T1, T2> val : values) {
                if (val.isOne()) {
                    oneValues.add(val.getOne());
                    continue;
                }
                twoValues.add(val.getTwo());
            }
            ((CoGroupFunction)this.wrappedFunction).coGroup(oneValues, twoValues, out);
        }
    }

    private static class UnionKeySelector<T1, T2, KEY>
    implements KeySelector<TaggedUnion<T1, T2>, KEY> {
        private static final long serialVersionUID = 1L;
        private final KeySelector<T1, KEY> keySelector1;
        private final KeySelector<T2, KEY> keySelector2;

        public UnionKeySelector(KeySelector<T1, KEY> keySelector1, KeySelector<T2, KEY> keySelector2) {
            this.keySelector1 = keySelector1;
            this.keySelector2 = keySelector2;
        }

        @Override
        public KEY getKey(TaggedUnion<T1, T2> value) throws Exception {
            if (value.isOne()) {
                return this.keySelector1.getKey(value.getOne());
            }
            return this.keySelector2.getKey(value.getTwo());
        }
    }

    private static class Input2Tagger<T1, T2>
    implements MapFunction<T2, TaggedUnion<T1, T2>> {
        private static final long serialVersionUID = 1L;

        private Input2Tagger() {
        }

        @Override
        public TaggedUnion<T1, T2> map(T2 value) throws Exception {
            return TaggedUnion.two(value);
        }
    }

    private static class Input1Tagger<T1, T2>
    implements MapFunction<T1, TaggedUnion<T1, T2>> {
        private static final long serialVersionUID = 1L;

        private Input1Tagger() {
        }

        @Override
        public TaggedUnion<T1, T2> map(T1 value) throws Exception {
            return TaggedUnion.one(value);
        }
    }

    public static class UnionSerializerSnapshot<T1, T2>
    extends CompositeTypeSerializerSnapshot<TaggedUnion<T1, T2>, UnionSerializer<T1, T2>> {
        private static final int VERSION = 2;

        public UnionSerializerSnapshot() {
            super(UnionSerializer.class);
        }

        UnionSerializerSnapshot(UnionSerializer<T1, T2> serializerInstance) {
            super(serializerInstance);
        }

        @Override
        protected int getCurrentOuterSnapshotVersion() {
            return 2;
        }

        @Override
        protected TypeSerializer<?>[] getNestedSerializers(UnionSerializer<T1, T2> outerSerializer) {
            return new TypeSerializer[]{((UnionSerializer)outerSerializer).oneSerializer, ((UnionSerializer)outerSerializer).twoSerializer};
        }

        @Override
        protected UnionSerializer<T1, T2> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            return new UnionSerializer(nestedSerializers[0], nestedSerializers[1]);
        }
    }

    @Deprecated
    public static class UnionSerializerConfigSnapshot<T1, T2>
    extends CompositeTypeSerializerConfigSnapshot<TaggedUnion<T1, T2>> {
        private static final int VERSION = 1;

        public UnionSerializerConfigSnapshot() {
        }

        public UnionSerializerConfigSnapshot(TypeSerializer<T1> oneSerializer, TypeSerializer<T2> twoSerializer) {
            super(oneSerializer, twoSerializer);
        }

        @Override
        public TypeSerializerSchemaCompatibility<TaggedUnion<T1, T2>> resolveSchemaCompatibility(TypeSerializer<TaggedUnion<T1, T2>> newSerializer) {
            List<Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> nestedSerializersAndConfigs = this.getNestedSerializersAndConfigs();
            return CompositeTypeSerializerUtil.delegateCompatibilityCheckToNewSnapshot(newSerializer, new UnionSerializerSnapshot(), (TypeSerializerSnapshot)nestedSerializersAndConfigs.get((int)0).f1, (TypeSerializerSnapshot)nestedSerializersAndConfigs.get((int)1).f1);
        }

        @Override
        public int getVersion() {
            return 1;
        }
    }

    @VisibleForTesting
    @Internal
    public static class UnionSerializer<T1, T2>
    extends TypeSerializer<TaggedUnion<T1, T2>> {
        private static final long serialVersionUID = 1L;
        private final TypeSerializer<T1> oneSerializer;
        private final TypeSerializer<T2> twoSerializer;

        public UnionSerializer(TypeSerializer<T1> oneSerializer, TypeSerializer<T2> twoSerializer) {
            this.oneSerializer = oneSerializer;
            this.twoSerializer = twoSerializer;
        }

        @Override
        public boolean isImmutableType() {
            return false;
        }

        @Override
        public TypeSerializer<TaggedUnion<T1, T2>> duplicate() {
            TypeSerializer<T1> duplicateOne = this.oneSerializer.duplicate();
            TypeSerializer<T2> duplicateTwo = this.twoSerializer.duplicate();
            if (duplicateOne != this.oneSerializer || duplicateTwo != this.twoSerializer) {
                return new UnionSerializer<T1, T2>(duplicateOne, duplicateTwo);
            }
            return this;
        }

        @Override
        public TaggedUnion<T1, T2> createInstance() {
            return TaggedUnion.one(this.oneSerializer.createInstance());
        }

        @Override
        public TaggedUnion<T1, T2> copy(TaggedUnion<T1, T2> from) {
            if (from.isOne()) {
                return TaggedUnion.one(this.oneSerializer.copy(from.getOne()));
            }
            return TaggedUnion.two(this.twoSerializer.copy(from.getTwo()));
        }

        @Override
        public TaggedUnion<T1, T2> copy(TaggedUnion<T1, T2> from, TaggedUnion<T1, T2> reuse) {
            if (from.isOne()) {
                return TaggedUnion.one(this.oneSerializer.copy(from.getOne()));
            }
            return TaggedUnion.two(this.twoSerializer.copy(from.getTwo()));
        }

        @Override
        public int getLength() {
            return -1;
        }

        @Override
        public void serialize(TaggedUnion<T1, T2> record, DataOutputView target) throws IOException {
            if (record.isOne()) {
                target.writeByte(1);
                this.oneSerializer.serialize(record.getOne(), target);
            } else {
                target.writeByte(2);
                this.twoSerializer.serialize(record.getTwo(), target);
            }
        }

        @Override
        public TaggedUnion<T1, T2> deserialize(DataInputView source) throws IOException {
            byte tag = source.readByte();
            if (tag == 1) {
                return TaggedUnion.one(this.oneSerializer.deserialize(source));
            }
            return TaggedUnion.two(this.twoSerializer.deserialize(source));
        }

        @Override
        public TaggedUnion<T1, T2> deserialize(TaggedUnion<T1, T2> reuse, DataInputView source) throws IOException {
            byte tag = source.readByte();
            if (tag == 1) {
                return TaggedUnion.one(this.oneSerializer.deserialize(source));
            }
            return TaggedUnion.two(this.twoSerializer.deserialize(source));
        }

        @Override
        public void copy(DataInputView source, DataOutputView target) throws IOException {
            byte tag = source.readByte();
            target.writeByte(tag);
            if (tag == 1) {
                this.oneSerializer.copy(source, target);
            } else {
                this.twoSerializer.copy(source, target);
            }
        }

        @Override
        public int hashCode() {
            return 31 * this.oneSerializer.hashCode() + this.twoSerializer.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof UnionSerializer) {
                UnionSerializer other = (UnionSerializer)obj;
                return this.oneSerializer.equals(other.oneSerializer) && this.twoSerializer.equals(other.twoSerializer);
            }
            return false;
        }

        @Override
        public TypeSerializerSnapshot<TaggedUnion<T1, T2>> snapshotConfiguration() {
            return new UnionSerializerSnapshot(this);
        }
    }

    private static class UnionTypeInfo<T1, T2>
    extends TypeInformation<TaggedUnion<T1, T2>> {
        private static final long serialVersionUID = 1L;
        private final TypeInformation<T1> oneType;
        private final TypeInformation<T2> twoType;

        public UnionTypeInfo(TypeInformation<T1> oneType, TypeInformation<T2> twoType) {
            this.oneType = oneType;
            this.twoType = twoType;
        }

        @Override
        public boolean isBasicType() {
            return false;
        }

        @Override
        public boolean isTupleType() {
            return false;
        }

        @Override
        public int getArity() {
            return 2;
        }

        @Override
        public int getTotalFields() {
            return 2;
        }

        @Override
        public Class<TaggedUnion<T1, T2>> getTypeClass() {
            return TaggedUnion.class;
        }

        @Override
        public boolean isKeyType() {
            return true;
        }

        @Override
        public TypeSerializer<TaggedUnion<T1, T2>> createSerializer(ExecutionConfig config) {
            return new UnionSerializer<T1, T2>(this.oneType.createSerializer(config), this.twoType.createSerializer(config));
        }

        @Override
        public String toString() {
            return "TaggedUnion<" + this.oneType + ", " + this.twoType + ">";
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof UnionTypeInfo) {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)obj;
                return unionTypeInfo.canEqual(this) && this.oneType.equals(unionTypeInfo.oneType) && this.twoType.equals(unionTypeInfo.twoType);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 31 * this.oneType.hashCode() + this.twoType.hashCode();
        }

        @Override
        public boolean canEqual(Object obj) {
            return obj instanceof UnionTypeInfo;
        }
    }

    @Internal
    public static class TaggedUnion<T1, T2> {
        private final T1 one;
        private final T2 two;

        private TaggedUnion(T1 one, T2 two) {
            this.one = one;
            this.two = two;
        }

        public boolean isOne() {
            return this.one != null;
        }

        public boolean isTwo() {
            return this.two != null;
        }

        public T1 getOne() {
            return this.one;
        }

        public T2 getTwo() {
            return this.two;
        }

        public static <T1, T2> TaggedUnion<T1, T2> one(T1 one) {
            return new TaggedUnion<T1, Object>(one, null);
        }

        public static <T1, T2> TaggedUnion<T1, T2> two(T2 two) {
            return new TaggedUnion<Object, T2>(null, two);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TaggedUnion)) {
                return false;
            }
            TaggedUnion other = (TaggedUnion)obj;
            return Objects.equals(this.one, other.one) && Objects.equals(this.two, other.two);
        }
    }

    @Public
    public static class WithWindow<T1, T2, KEY, W extends Window> {
        private final DataStream<T1> input1;
        private final DataStream<T2> input2;
        private final KeySelector<T1, KEY> keySelector1;
        private final KeySelector<T2, KEY> keySelector2;
        private final TypeInformation<KEY> keyType;
        private final WindowAssigner<? super TaggedUnion<T1, T2>, W> windowAssigner;
        private final Trigger<? super TaggedUnion<T1, T2>, ? super W> trigger;
        private final Evictor<? super TaggedUnion<T1, T2>, ? super W> evictor;
        private final Time allowedLateness;
        private WindowedStream<TaggedUnion<T1, T2>, KEY, W> windowedStream;

        protected WithWindow(DataStream<T1> input1, DataStream<T2> input2, KeySelector<T1, KEY> keySelector1, KeySelector<T2, KEY> keySelector2, TypeInformation<KEY> keyType, WindowAssigner<? super TaggedUnion<T1, T2>, W> windowAssigner, Trigger<? super TaggedUnion<T1, T2>, ? super W> trigger, Evictor<? super TaggedUnion<T1, T2>, ? super W> evictor, Time allowedLateness) {
            this.input1 = input1;
            this.input2 = input2;
            this.keySelector1 = keySelector1;
            this.keySelector2 = keySelector2;
            this.keyType = keyType;
            this.windowAssigner = windowAssigner;
            this.trigger = trigger;
            this.evictor = evictor;
            this.allowedLateness = allowedLateness;
        }

        @PublicEvolving
        public WithWindow<T1, T2, KEY, W> trigger(Trigger<? super TaggedUnion<T1, T2>, ? super W> newTrigger) {
            return new WithWindow<T1, T2, KEY, W>(this.input1, this.input2, this.keySelector1, this.keySelector2, this.keyType, this.windowAssigner, newTrigger, this.evictor, this.allowedLateness);
        }

        @PublicEvolving
        public WithWindow<T1, T2, KEY, W> evictor(Evictor<? super TaggedUnion<T1, T2>, ? super W> newEvictor) {
            return new WithWindow<T1, T2, KEY, W>(this.input1, this.input2, this.keySelector1, this.keySelector2, this.keyType, this.windowAssigner, this.trigger, newEvictor, this.allowedLateness);
        }

        @PublicEvolving
        public WithWindow<T1, T2, KEY, W> allowedLateness(Time newLateness) {
            return new WithWindow<T1, T2, KEY, W>(this.input1, this.input2, this.keySelector1, this.keySelector2, this.keyType, this.windowAssigner, this.trigger, this.evictor, newLateness);
        }

        public <T> DataStream<T> apply(CoGroupFunction<T1, T2, T> function) {
            TypeInformation<T> resultType = TypeExtractor.getCoGroupReturnTypes(function, this.input1.getType(), this.input2.getType(), "CoGroup", false);
            return this.apply(function, resultType);
        }

        @Deprecated
        @PublicEvolving
        public <T> SingleOutputStreamOperator<T> with(CoGroupFunction<T1, T2, T> function) {
            return (SingleOutputStreamOperator)this.apply(function);
        }

        public <T> DataStream<T> apply(CoGroupFunction<T1, T2, T> function, TypeInformation<T> resultType) {
            function = this.input1.getExecutionEnvironment().clean(function);
            UnionTypeInfo<T1, T2> unionType = new UnionTypeInfo<T1, T2>(this.input1.getType(), this.input2.getType());
            UnionKeySelector<T1, T2, KEY> unionKeySelector = new UnionKeySelector<T1, T2, KEY>(this.keySelector1, this.keySelector2);
            SingleOutputStreamOperator taggedInput1 = this.input1.map(new Input1Tagger()).setParallelism(this.input1.getParallelism()).returns(unionType);
            SingleOutputStreamOperator taggedInput2 = this.input2.map(new Input2Tagger()).setParallelism(this.input2.getParallelism()).returns(unionType);
            DataStream unionStream = taggedInput1.union(taggedInput2);
            this.windowedStream = new KeyedStream<TaggedUnion<T1, T2>, KEY>(unionStream, unionKeySelector, this.keyType).window(this.windowAssigner);
            if (this.trigger != null) {
                this.windowedStream.trigger(this.trigger);
            }
            if (this.evictor != null) {
                this.windowedStream.evictor(this.evictor);
            }
            if (this.allowedLateness != null) {
                this.windowedStream.allowedLateness(this.allowedLateness);
            }
            return this.windowedStream.apply(new CoGroupWindowFunction(function), resultType);
        }

        @Deprecated
        @PublicEvolving
        public <T> SingleOutputStreamOperator<T> with(CoGroupFunction<T1, T2, T> function, TypeInformation<T> resultType) {
            return (SingleOutputStreamOperator)this.apply(function, resultType);
        }

        @VisibleForTesting
        Time getAllowedLateness() {
            return this.allowedLateness;
        }

        @VisibleForTesting
        WindowedStream<TaggedUnion<T1, T2>, KEY, W> getWindowedStream() {
            return this.windowedStream;
        }
    }

    @Public
    public class Where<KEY> {
        private final KeySelector<T1, KEY> keySelector1;
        private final TypeInformation<KEY> keyType;

        Where(KeySelector<T1, KEY> keySelector1, TypeInformation<KEY> keyType) {
            this.keySelector1 = keySelector1;
            this.keyType = keyType;
        }

        public EqualTo equalTo(KeySelector<T2, KEY> keySelector) {
            Preconditions.checkNotNull(keySelector);
            TypeInformation<KEY> otherKey = TypeExtractor.getKeySelectorTypes(keySelector, CoGroupedStreams.this.input2.getType());
            return this.equalTo(keySelector, otherKey);
        }

        public EqualTo equalTo(KeySelector<T2, KEY> keySelector, TypeInformation<KEY> keyType) {
            Preconditions.checkNotNull(keySelector);
            Preconditions.checkNotNull(keyType);
            if (!keyType.equals(this.keyType)) {
                throw new IllegalArgumentException("The keys for the two inputs are not equal: first key = " + this.keyType + " , second key = " + keyType);
            }
            return new EqualTo(CoGroupedStreams.this.input2.clean(keySelector));
        }

        @Public
        public class EqualTo {
            private final KeySelector<T2, KEY> keySelector2;

            EqualTo(KeySelector<T2, KEY> keySelector2) {
                this.keySelector2 = Objects.requireNonNull(keySelector2);
            }

            @PublicEvolving
            public <W extends Window> WithWindow<T1, T2, KEY, W> window(WindowAssigner<? super TaggedUnion<T1, T2>, W> assigner) {
                return new WithWindow(CoGroupedStreams.this.input1, CoGroupedStreams.this.input2, Where.this.keySelector1, this.keySelector2, Where.this.keyType, assigner, null, null, null);
            }
        }
    }
}

