/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.connector.sink2;

import java.util.Objects;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializerTypeSerializerProxy;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessageSerializer;
import org.apache.flink.util.function.SerializableSupplier;

@Experimental
public class CommittableMessageTypeInfo<CommT>
extends TypeInformation<CommittableMessage<CommT>> {
    private final SerializableSupplier<SimpleVersionedSerializer<CommT>> committableSerializerFactory;

    private CommittableMessageTypeInfo(SerializableSupplier<SimpleVersionedSerializer<CommT>> committableSerializerFactory) {
        this.committableSerializerFactory = committableSerializerFactory;
    }

    public static <CommT> TypeInformation<CommittableMessage<CommT>> of(SerializableSupplier<SimpleVersionedSerializer<CommT>> committableSerializerFactory) {
        return new CommittableMessageTypeInfo<CommT>(committableSerializerFactory);
    }

    public static TypeInformation<CommittableMessage<Void>> noOutput() {
        return new CommittableMessageTypeInfo<Void>(() -> new NoOutputSerializer());
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<CommittableMessage<CommT>> getTypeClass() {
        return CommittableMessage.class;
    }

    @Override
    public boolean isKeyType() {
        return false;
    }

    @Override
    public TypeSerializer<CommittableMessage<CommT>> createSerializer(ExecutionConfig config) {
        return new SimpleVersionedSerializerTypeSerializerProxy<CommittableMessage<CommT>>(() -> new CommittableMessageSerializer((SimpleVersionedSerializer)this.committableSerializerFactory.get())){

            @Override
            public CommittableMessage<CommT> copy(CommittableMessage<CommT> from) {
                return from;
            }

            @Override
            public CommittableMessage<CommT> copy(CommittableMessage<CommT> from, CommittableMessage<CommT> reuse) {
                return from;
            }
        };
    }

    @Override
    public String toString() {
        return "CommittableMessageTypeInfo{serializer=" + this.committableSerializerFactory.get() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.canEqual(o)) {
            return false;
        }
        CommittableMessageTypeInfo that = (CommittableMessageTypeInfo)o;
        return Objects.equals(((SimpleVersionedSerializer)this.committableSerializerFactory.get()).getClass(), ((SimpleVersionedSerializer)that.committableSerializerFactory.get()).getClass());
    }

    @Override
    public int hashCode() {
        return Objects.hash(((SimpleVersionedSerializer)this.committableSerializerFactory.get()).getClass());
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof CommittableMessageTypeInfo;
    }

    private static class NoOutputSerializer
    implements SimpleVersionedSerializer<Void> {
        private NoOutputSerializer() {
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public byte[] serialize(Void obj) {
            throw new IllegalStateException("Should not serialize anything");
        }

        @Override
        public Void deserialize(int version, byte[] serialized) {
            throw new IllegalStateException("Should not deserialize anything");
        }
    }
}

