/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.flink.runtime.io.compression.BlockDecompressor;
import org.apache.flink.runtime.io.compression.BufferDecompressionException;
import org.apache.flink.runtime.io.compression.CompressorUtils;

public class Lz4BlockDecompressor
implements BlockDecompressor {
    private final LZ4FastDecompressor decompressor = LZ4Factory.fastestInstance().fastDecompressor();

    @Override
    public int decompress(ByteBuffer src, int srcOff, int srcLen, ByteBuffer dst, int dstOff) throws BufferDecompressionException {
        int prevSrcOff = src.position() + srcOff;
        int prevDstOff = dst.position() + dstOff;
        src.order(ByteOrder.LITTLE_ENDIAN);
        int compressedLen = src.getInt(prevSrcOff);
        int originalLen = src.getInt(prevSrcOff + 4);
        CompressorUtils.validateLength(compressedLen, originalLen);
        if (dst.capacity() - prevDstOff < originalLen) {
            throw new BufferDecompressionException("Buffer length too small");
        }
        if (src.limit() - prevSrcOff - 8 < compressedLen) {
            throw new BufferDecompressionException("Source data is not integral for decompression.");
        }
        try {
            int compressedLen2 = this.decompressor.decompress(src, prevSrcOff + 8, dst, prevDstOff, originalLen);
            if (compressedLen != compressedLen2) {
                throw new BufferDecompressionException("Input is corrupted, unexpected compressed length.");
            }
            src.position(prevSrcOff + compressedLen + 8);
            dst.position(prevDstOff + originalLen);
        }
        catch (LZ4Exception e) {
            throw new BufferDecompressionException("Input is corrupted", e);
        }
        return originalLen;
    }

    @Override
    public int decompress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws BufferDecompressionException {
        int compressedLen = CompressorUtils.readIntLE(src, srcOff);
        int originalLen = CompressorUtils.readIntLE(src, srcOff + 4);
        CompressorUtils.validateLength(compressedLen, originalLen);
        if (dst.length - dstOff < originalLen) {
            throw new BufferDecompressionException("Buffer length too small");
        }
        if (src.length - srcOff - 8 < compressedLen) {
            throw new BufferDecompressionException("Source data is not integral for decompression.");
        }
        try {
            int compressedLen2 = this.decompressor.decompress(src, srcOff + 8, dst, dstOff, originalLen);
            if (compressedLen != compressedLen2) {
                throw new BufferDecompressionException("Input is corrupted");
            }
        }
        catch (LZ4Exception e) {
            throw new BufferDecompressionException("Input is corrupted", e);
        }
        return originalLen;
    }
}

