/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.Path;

class HadoopFsRecoverable
implements RecoverableWriter.CommitRecoverable,
RecoverableWriter.ResumeRecoverable {
    private final Path targetFile;
    private final Path tempFile;
    private final long offset;

    HadoopFsRecoverable(Path targetFile, Path tempFile, long offset) {
        Preconditions.checkArgument(offset >= 0L, "offset must be >= 0");
        this.targetFile = Preconditions.checkNotNull(targetFile, "targetFile");
        this.tempFile = Preconditions.checkNotNull(tempFile, "tempFile");
        this.offset = offset;
    }

    public Path targetFile() {
        return this.targetFile;
    }

    public Path tempFile() {
        return this.tempFile;
    }

    public long offset() {
        return this.offset;
    }

    public String toString() {
        return "HadoopFsRecoverable " + this.tempFile + " @ " + this.offset + " -> " + this.targetFile;
    }
}

