/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartBackoffTimeStrategy;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class ExponentialDelayRestartBackoffTimeStrategy
implements RestartBackoffTimeStrategy {
    private final long initialBackoffMS;
    private final long maxBackoffMS;
    private final double backoffMultiplier;
    private final long resetBackoffThresholdMS;
    private final double jitterFactor;
    private final String strategyString;
    private final Clock clock;
    private long currentBackoffMS;
    private long lastFailureTimestamp;

    ExponentialDelayRestartBackoffTimeStrategy(Clock clock, long initialBackoffMS, long maxBackoffMS, double backoffMultiplier, long resetBackoffThresholdMS, double jitterFactor) {
        Preconditions.checkArgument(initialBackoffMS >= 1L, "Initial backoff must be at least 1.");
        Preconditions.checkArgument(maxBackoffMS >= 1L, "Maximum backoff must be at least 1.");
        Preconditions.checkArgument(initialBackoffMS <= maxBackoffMS, "Initial backoff cannot be higher than maximum backoff.");
        Preconditions.checkArgument(backoffMultiplier > 1.0, "Backoff multiplier must be greater than 1.");
        Preconditions.checkArgument(resetBackoffThresholdMS >= 1L, "Threshold duration for exponential backoff reset must be at least 1.");
        Preconditions.checkArgument(0.0 <= jitterFactor && jitterFactor <= 1.0, "Jitter factor must be >= 0 and <= 1.");
        this.initialBackoffMS = initialBackoffMS;
        this.setInitialBackoff();
        this.maxBackoffMS = maxBackoffMS;
        this.backoffMultiplier = backoffMultiplier;
        this.resetBackoffThresholdMS = resetBackoffThresholdMS;
        this.jitterFactor = jitterFactor;
        this.clock = Preconditions.checkNotNull(clock);
        this.lastFailureTimestamp = 0L;
        this.strategyString = this.generateStrategyString();
    }

    @Override
    public boolean canRestart() {
        return true;
    }

    @Override
    public long getBackoffTime() {
        long backoffWithJitter = this.currentBackoffMS + this.calculateJitterBackoffMS();
        return Math.min(backoffWithJitter, this.maxBackoffMS);
    }

    @Override
    public void notifyFailure(Throwable cause) {
        long now = this.clock.absoluteTimeMillis();
        if (now - this.lastFailureTimestamp >= this.resetBackoffThresholdMS + this.currentBackoffMS) {
            this.setInitialBackoff();
        } else {
            this.increaseBackoff();
        }
        this.lastFailureTimestamp = now;
    }

    public String toString() {
        return this.strategyString;
    }

    private void setInitialBackoff() {
        this.currentBackoffMS = this.initialBackoffMS;
    }

    private void increaseBackoff() {
        if (this.currentBackoffMS < this.maxBackoffMS) {
            this.currentBackoffMS = (long)((double)this.currentBackoffMS * this.backoffMultiplier);
        }
        this.currentBackoffMS = Math.max(this.initialBackoffMS, Math.min(this.currentBackoffMS, this.maxBackoffMS));
    }

    private long calculateJitterBackoffMS() {
        if (this.jitterFactor == 0.0) {
            return 0L;
        }
        long offset = (long)((double)this.currentBackoffMS * this.jitterFactor);
        return ThreadLocalRandom.current().nextLong(-offset, offset + 1L);
    }

    private String generateStrategyString() {
        return "ExponentialDelayRestartBackoffTimeStrategy(initialBackoffMS=" + this.initialBackoffMS + ", maxBackoffMS=" + this.maxBackoffMS + ", backoffMultiplier=" + this.backoffMultiplier + ", resetBackoffThresholdMS=" + this.resetBackoffThresholdMS + ", jitterFactor=" + this.jitterFactor + ", currentBackoffMS=" + this.currentBackoffMS + ", lastFailureTimestamp=" + this.lastFailureTimestamp + ")";
    }

    public static ExponentialDelayRestartBackoffTimeStrategyFactory createFactory(Configuration configuration) {
        long initialBackoffMS = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF).toMillis();
        long maxBackoffMS = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF).toMillis();
        double backoffMultiplier = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_BACKOFF_MULTIPLIER);
        long resetBackoffThresholdMS = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_RESET_BACKOFF_THRESHOLD).toMillis();
        double jitterFactor = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_JITTER_FACTOR);
        return new ExponentialDelayRestartBackoffTimeStrategyFactory(initialBackoffMS, maxBackoffMS, backoffMultiplier, resetBackoffThresholdMS, jitterFactor);
    }

    public static class ExponentialDelayRestartBackoffTimeStrategyFactory
    implements RestartBackoffTimeStrategy.Factory {
        private final long initialBackoffMS;
        private final long maxBackoffMS;
        private final double backoffMultiplier;
        private final long resetBackoffThresholdMS;
        private final double jitterFactor;

        public ExponentialDelayRestartBackoffTimeStrategyFactory(long initialBackoffMS, long maxBackoffMS, double backoffMultiplier, long resetBackoffThresholdMS, double jitterFactor) {
            this.initialBackoffMS = initialBackoffMS;
            this.maxBackoffMS = maxBackoffMS;
            this.backoffMultiplier = backoffMultiplier;
            this.resetBackoffThresholdMS = resetBackoffThresholdMS;
            this.jitterFactor = jitterFactor;
        }

        @Override
        public RestartBackoffTimeStrategy create() {
            return new ExponentialDelayRestartBackoffTimeStrategy(SystemClock.getInstance(), this.initialBackoffMS, this.maxBackoffMS, this.backoffMultiplier, this.resetBackoffThresholdMS, this.jitterFactor);
        }
    }
}

