/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.compactor;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.connector.file.sink.compactor.RecordWiseFileCompactor;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.function.SerializableSupplierWithException;

@PublicEvolving
public class InputFormatBasedReader<T>
implements RecordWiseFileCompactor.Reader<T> {
    private final Path path;
    private final FileInputFormat<T> inputFormat;

    public InputFormatBasedReader(Path path, FileInputFormat<T> inputFormat) throws IOException {
        this.path = path;
        this.inputFormat = inputFormat;
        this.open();
    }

    private void open() throws IOException {
        long len = this.path.getFileSystem().getFileStatus(this.path).getLen();
        this.inputFormat.open(new FileInputSplit(0, this.path, 0L, len, null));
    }

    @Override
    public T read() throws IOException {
        if (this.inputFormat.reachedEnd()) {
            return null;
        }
        return this.inputFormat.nextRecord(null);
    }

    @Override
    public void close() throws IOException {
        this.inputFormat.close();
    }

    public static class Factory<T>
    implements RecordWiseFileCompactor.Reader.Factory<T> {
        private final SerializableSupplierWithException<FileInputFormat<T>, IOException> inputFormatFactory;

        public Factory(SerializableSupplierWithException<FileInputFormat<T>, IOException> inputFormatFactory) {
            this.inputFormatFactory = inputFormatFactory;
        }

        @Override
        public InputFormatBasedReader<T> createFor(Path path) throws IOException {
            return new InputFormatBasedReader(path, (FileInputFormat)this.inputFormatFactory.get());
        }
    }
}

