/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.util.OptionalFailure;

@Public
public class JobExecutionResult
extends JobSubmissionResult {
    private final long netRuntime;
    private final Map<String, OptionalFailure<Object>> accumulatorResults;

    public JobExecutionResult(JobID jobID, long netRuntime, Map<String, OptionalFailure<Object>> accumulators) {
        super(jobID);
        this.netRuntime = netRuntime;
        this.accumulatorResults = accumulators != null ? accumulators : Collections.emptyMap();
    }

    @Override
    public boolean isJobExecutionResult() {
        return true;
    }

    @Override
    public JobExecutionResult getJobExecutionResult() {
        return this;
    }

    public long getNetRuntime() {
        return this.netRuntime;
    }

    public long getNetRuntime(TimeUnit desiredUnit) {
        return desiredUnit.convert(this.getNetRuntime(), TimeUnit.MILLISECONDS);
    }

    public <T> T getAccumulatorResult(String accumulatorName) {
        OptionalFailure<Object> result = this.accumulatorResults.get(accumulatorName);
        if (result != null) {
            return (T)result.getUnchecked();
        }
        return null;
    }

    public Map<String, Object> getAllAccumulatorResults() {
        return this.accumulatorResults.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((OptionalFailure)entry.getValue()).getUnchecked()));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Program execution finished").append("\n");
        result.append("Job with JobID ").append(this.getJobID()).append(" has finished.").append("\n");
        result.append("Job Runtime: ").append(this.getNetRuntime()).append(" ms").append("\n");
        Map<String, Object> accumulatorsResult = this.getAllAccumulatorResults();
        if (accumulatorsResult.size() > 0) {
            result.append("Accumulator Results: ").append("\n");
            result.append(AccumulatorHelper.getResultsFormatted(accumulatorsResult)).append("\n");
        }
        return result.toString();
    }

    @Deprecated
    @PublicEvolving
    public Integer getIntCounterResult(String accumulatorName) {
        Object result = this.accumulatorResults.get(accumulatorName).getUnchecked();
        if (result == null) {
            return null;
        }
        if (!(result instanceof Integer)) {
            throw new ClassCastException("Requested result of the accumulator '" + accumulatorName + "' should be Integer but has type " + result.getClass());
        }
        return (Integer)result;
    }

    @Deprecated
    public static JobExecutionResult fromJobSubmissionResult(JobSubmissionResult result) {
        return new JobExecutionResult(result.getJobID(), -1L, null);
    }
}

