/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.parquet.format.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.table.store.shaded.org.apache.parquet.CorruptStatistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.ParquetReadOptions;
import org.apache.flink.table.store.shaded.org.apache.parquet.Preconditions;
import org.apache.flink.table.store.shaded.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.EncodingStats;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.AesCipher;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.AesGcmEncryptor;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.InternalColumnEncryptionSetup;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.InternalFileEncryptor;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.flink.table.store.shaded.org.apache.parquet.crypto.TagVerificationException;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.BlockCipher;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.BloomFilterAlgorithm;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.BloomFilterCompression;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.BloomFilterHash;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.BloomFilterHeader;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.BoundaryOrder;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.BsonType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.ColumnChunk;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.ColumnCryptoMetaData;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.ColumnIndex;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.ColumnMetaData;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.ColumnOrder;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.CompressionCodec;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.ConvertedType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.DataPageHeader;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.DataPageHeaderV2;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.DateType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.DecimalType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.DictionaryPageHeader;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.Encoding;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.EncryptionWithColumnKey;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.EnumType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.FieldRepetitionType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.FileMetaData;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.IntType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.JsonType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.KeyValue;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.ListType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.LogicalType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.MapType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.MicroSeconds;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.MilliSeconds;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.NanoSeconds;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.NullType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.OffsetIndex;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.PageEncodingStats;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.PageHeader;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.PageLocation;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.PageType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.RowGroup;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.SchemaElement;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.SplitBlockAlgorithm;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.Statistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.StringType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.TimeType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.TimeUnit;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.TimestampType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.Type;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.TypeDefinedOrder;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.UUIDType;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.Uncompressed;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.Util;
import org.apache.flink.table.store.shaded.org.apache.parquet.format.XxHash;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.flink.table.store.shaded.org.apache.parquet.internal.column.columnindex.BinaryTruncator;
import org.apache.flink.table.store.shaded.org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.flink.table.store.shaded.org.apache.parquet.internal.column.columnindex.OffsetIndexBuilder;
import org.apache.flink.table.store.shaded.org.apache.parquet.internal.hadoop.metadata.IndexReference;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.InvalidFileOffsetException;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.ParquetDecodingException;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.api.Binary;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.ColumnOrder;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.GroupType;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.MessageType;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.OriginalType;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.Type;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.TypeVisitor;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.Types;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetMetadataConverter {
    private static final TypeDefinedOrder TYPE_DEFINED_ORDER = new TypeDefinedOrder();
    public static final MetadataFilter NO_FILTER = new NoFilter();
    public static final MetadataFilter SKIP_ROW_GROUPS = new SkipMetadataFilter();
    public static final long MAX_STATS_SIZE = 4096L;
    private static final Logger LOG = LoggerFactory.getLogger(ParquetMetadataConverter.class);
    private static final LogicalTypeConverterVisitor LOGICAL_TYPE_ANNOTATION_VISITOR = new LogicalTypeConverterVisitor();
    private static final ConvertedTypeConverterVisitor CONVERTED_TYPE_CONVERTER_VISITOR = new ConvertedTypeConverterVisitor();
    private final int statisticsTruncateLength;
    private final boolean useSignedStringMinMax;
    private static final ConcurrentHashMap<Set<org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding>, Set<org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding>> cachedEncodingSets = new ConcurrentHashMap();
    private static final Set<Class> STRING_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(LogicalTypeAnnotation.StringLogicalTypeAnnotation.class, LogicalTypeAnnotation.EnumLogicalTypeAnnotation.class, LogicalTypeAnnotation.JsonLogicalTypeAnnotation.class)));

    public ParquetMetadataConverter() {
        this(false);
    }

    public ParquetMetadataConverter(int statisticsTruncateLength) {
        this(false, statisticsTruncateLength);
    }

    @Deprecated
    public ParquetMetadataConverter(Configuration conf) {
        this(conf.getBoolean("parquet.strings.signed-min-max.enabled", false));
    }

    public ParquetMetadataConverter(ParquetReadOptions options) {
        this(options.useSignedStringMinMax());
    }

    private ParquetMetadataConverter(boolean useSignedStringMinMax) {
        this(useSignedStringMinMax, Integer.MAX_VALUE);
    }

    private ParquetMetadataConverter(boolean useSignedStringMinMax, int statisticsTruncateLength) {
        if (statisticsTruncateLength <= 0) {
            throw new IllegalArgumentException("Truncate length should be greater than 0");
        }
        this.useSignedStringMinMax = useSignedStringMinMax;
        this.statisticsTruncateLength = statisticsTruncateLength;
    }

    public FileMetaData toParquetMetadata(int currentVersion, ParquetMetadata parquetMetadata) {
        return this.toParquetMetadata(currentVersion, parquetMetadata, null);
    }

    public FileMetaData toParquetMetadata(int currentVersion, ParquetMetadata parquetMetadata, InternalFileEncryptor fileEncryptor) {
        List<BlockMetaData> blocks = parquetMetadata.getBlocks();
        ArrayList<RowGroup> rowGroups = new ArrayList<RowGroup>();
        long numRows = 0L;
        long preBlockStartPos = 0L;
        long preBlockCompressedSize = 0L;
        for (BlockMetaData block : blocks) {
            numRows += block.getRowCount();
            long blockStartPos = block.getStartingPos();
            if (blockStartPos == 4L) {
                preBlockStartPos = 0L;
                preBlockCompressedSize = 0L;
            }
            if (preBlockStartPos != 0L) {
                Preconditions.checkState(blockStartPos >= preBlockStartPos + preBlockCompressedSize, "Invalid block starting position:" + blockStartPos);
            }
            preBlockStartPos = blockStartPos;
            preBlockCompressedSize = block.getCompressedSize();
            this.addRowGroup(parquetMetadata, rowGroups, block, fileEncryptor);
        }
        FileMetaData fileMetaData = new FileMetaData(currentVersion, this.toParquetSchema(parquetMetadata.getFileMetaData().getSchema()), numRows, rowGroups);
        Set<Map.Entry<String, String>> keyValues = parquetMetadata.getFileMetaData().getKeyValueMetaData().entrySet();
        for (Map.Entry<String, String> keyValue : keyValues) {
            ParquetMetadataConverter.addKeyValue(fileMetaData, keyValue.getKey(), keyValue.getValue());
        }
        fileMetaData.setCreated_by(parquetMetadata.getFileMetaData().getCreatedBy());
        fileMetaData.setColumn_orders(this.getColumnOrders(parquetMetadata.getFileMetaData().getSchema()));
        return fileMetaData;
    }

    private List<ColumnOrder> getColumnOrders(MessageType schema) {
        ArrayList<ColumnOrder> columnOrders = new ArrayList<ColumnOrder>();
        int n = schema.getPaths().size();
        for (int i = 0; i < n; ++i) {
            ColumnOrder columnOrder = new ColumnOrder();
            columnOrder.setTYPE_ORDER(TYPE_DEFINED_ORDER);
            columnOrders.add(columnOrder);
        }
        return columnOrders;
    }

    List<SchemaElement> toParquetSchema(MessageType schema) {
        ArrayList<SchemaElement> result = new ArrayList<SchemaElement>();
        this.addToList(result, schema);
        return result;
    }

    private void addToList(final List<SchemaElement> result, org.apache.flink.table.store.shaded.org.apache.parquet.schema.Type field) {
        field.accept(new TypeVisitor(){

            @Override
            public void visit(PrimitiveType primitiveType) {
                SchemaElement element = new SchemaElement(primitiveType.getName());
                element.setRepetition_type(ParquetMetadataConverter.this.toParquetRepetition(primitiveType.getRepetition()));
                element.setType(ParquetMetadataConverter.this.getType(primitiveType.getPrimitiveTypeName()));
                if (primitiveType.getLogicalTypeAnnotation() != null) {
                    element.setConverted_type(ParquetMetadataConverter.this.convertToConvertedType(primitiveType.getLogicalTypeAnnotation()));
                    element.setLogicalType(ParquetMetadataConverter.this.convertToLogicalType(primitiveType.getLogicalTypeAnnotation()));
                }
                if (primitiveType.getDecimalMetadata() != null) {
                    element.setPrecision(primitiveType.getDecimalMetadata().getPrecision());
                    element.setScale(primitiveType.getDecimalMetadata().getScale());
                }
                if (primitiveType.getTypeLength() > 0) {
                    element.setType_length(primitiveType.getTypeLength());
                }
                if (primitiveType.getId() != null) {
                    element.setField_id(primitiveType.getId().intValue());
                }
                result.add(element);
            }

            @Override
            public void visit(MessageType messageType) {
                SchemaElement element = new SchemaElement(messageType.getName());
                if (messageType.getId() != null) {
                    element.setField_id(messageType.getId().intValue());
                }
                this.visitChildren(result, messageType.asGroupType(), element);
            }

            @Override
            public void visit(GroupType groupType) {
                SchemaElement element = new SchemaElement(groupType.getName());
                element.setRepetition_type(ParquetMetadataConverter.this.toParquetRepetition(groupType.getRepetition()));
                if (groupType.getLogicalTypeAnnotation() != null) {
                    element.setConverted_type(ParquetMetadataConverter.this.convertToConvertedType(groupType.getLogicalTypeAnnotation()));
                    element.setLogicalType(ParquetMetadataConverter.this.convertToLogicalType(groupType.getLogicalTypeAnnotation()));
                }
                if (groupType.getId() != null) {
                    element.setField_id(groupType.getId().intValue());
                }
                this.visitChildren(result, groupType, element);
            }

            private void visitChildren(List<SchemaElement> result2, GroupType groupType, SchemaElement element) {
                element.setNum_children(groupType.getFieldCount());
                result2.add(element);
                for (org.apache.flink.table.store.shaded.org.apache.parquet.schema.Type field : groupType.getFields()) {
                    ParquetMetadataConverter.this.addToList(result2, field);
                }
            }
        });
    }

    LogicalType convertToLogicalType(LogicalTypeAnnotation logicalTypeAnnotation) {
        return logicalTypeAnnotation.accept(LOGICAL_TYPE_ANNOTATION_VISITOR).orElse(null);
    }

    ConvertedType convertToConvertedType(LogicalTypeAnnotation logicalTypeAnnotation) {
        return logicalTypeAnnotation.accept(CONVERTED_TYPE_CONVERTER_VISITOR).orElse(null);
    }

    static TimeUnit convertUnit(LogicalTypeAnnotation.TimeUnit unit) {
        switch (unit) {
            case MICROS: {
                return TimeUnit.MICROS(new MicroSeconds());
            }
            case MILLIS: {
                return TimeUnit.MILLIS(new MilliSeconds());
            }
            case NANOS: {
                return TimeUnit.NANOS(new NanoSeconds());
            }
        }
        throw new RuntimeException("Unknown time unit " + (Object)((Object)unit));
    }

    private void addRowGroup(ParquetMetadata parquetMetadata, List<RowGroup> rowGroups, BlockMetaData block, InternalFileEncryptor fileEncryptor) {
        List<ColumnChunkMetaData> columns = block.getColumns();
        ArrayList<ColumnChunk> parquetColumns = new ArrayList<ColumnChunk>();
        int rowGroupOrdinal = rowGroups.size();
        int columnOrdinal = -1;
        ByteArrayOutputStream tempOutStream = null;
        for (ColumnChunkMetaData columnMetaData : columns) {
            IndexReference offsetIndexRef;
            IndexReference columnIndexRef;
            long bloomFilterOffset;
            ColumnChunk columnChunk = new ColumnChunk(columnMetaData.getFirstDataPageOffset());
            columnChunk.file_path = block.getPath();
            InternalColumnEncryptionSetup columnSetup = null;
            boolean writeCryptoMetadata = false;
            boolean encryptMetaData = false;
            ColumnPath path = columnMetaData.getPath();
            if (null != fileEncryptor) {
                columnSetup = fileEncryptor.getColumnSetup(path, false, ++columnOrdinal);
                writeCryptoMetadata = columnSetup.isEncrypted();
                encryptMetaData = fileEncryptor.encryptColumnMetaData(columnSetup);
            }
            ColumnMetaData metaData = new ColumnMetaData(this.getType(columnMetaData.getType()), this.toFormatEncodings(columnMetaData.getEncodings()), Arrays.asList(columnMetaData.getPath().toArray()), this.toFormatCodec(columnMetaData.getCodec()), columnMetaData.getValueCount(), columnMetaData.getTotalUncompressedSize(), columnMetaData.getTotalSize(), columnMetaData.getFirstDataPageOffset());
            if (columnMetaData.getEncodingStats() != null && columnMetaData.getEncodingStats().hasDictionaryPages()) {
                metaData.setDictionary_page_offset(columnMetaData.getDictionaryPageOffset());
            }
            if ((bloomFilterOffset = columnMetaData.getBloomFilterOffset()) >= 0L) {
                metaData.setBloom_filter_offset(bloomFilterOffset);
            }
            if (columnMetaData.getStatistics() != null && !columnMetaData.getStatistics().isEmpty()) {
                metaData.setStatistics(ParquetMetadataConverter.toParquetStatistics(columnMetaData.getStatistics(), this.statisticsTruncateLength));
            }
            if (columnMetaData.getEncodingStats() != null) {
                metaData.setEncoding_stats(this.convertEncodingStats(columnMetaData.getEncodingStats()));
            }
            if (!encryptMetaData) {
                columnChunk.setMeta_data(metaData);
            } else {
                byte[] columnMetaDataAAD = AesCipher.createModuleAAD(fileEncryptor.getFileAAD(), ModuleCipherFactory.ModuleType.ColumnMetaData, rowGroupOrdinal, columnSetup.getOrdinal(), -1);
                if (null == tempOutStream) {
                    tempOutStream = new ByteArrayOutputStream();
                } else {
                    tempOutStream.reset();
                }
                try {
                    Util.writeColumnMetaData(metaData, tempOutStream, columnSetup.getMetaDataEncryptor(), columnMetaDataAAD);
                }
                catch (IOException e) {
                    throw new ParquetCryptoRuntimeException("Failed to serialize and encrypt ColumnMetadata for " + columnMetaData.getPath(), e);
                }
                columnChunk.setEncrypted_column_metadata(tempOutStream.toByteArray());
                if (!fileEncryptor.isFooterEncrypted()) {
                    ColumnMetaData metaDataRedacted = metaData.deepCopy();
                    if (metaDataRedacted.isSetStatistics()) {
                        metaDataRedacted.unsetStatistics();
                    }
                    if (metaDataRedacted.isSetEncoding_stats()) {
                        metaDataRedacted.unsetEncoding_stats();
                    }
                    columnChunk.setMeta_data(metaDataRedacted);
                }
            }
            if (writeCryptoMetadata) {
                columnChunk.setCrypto_metadata(columnSetup.getColumnCryptoMetaData());
            }
            if ((columnIndexRef = columnMetaData.getColumnIndexReference()) != null) {
                columnChunk.setColumn_index_offset(columnIndexRef.getOffset());
                columnChunk.setColumn_index_length(columnIndexRef.getLength());
            }
            if ((offsetIndexRef = columnMetaData.getOffsetIndexReference()) != null) {
                columnChunk.setOffset_index_offset(offsetIndexRef.getOffset());
                columnChunk.setOffset_index_length(offsetIndexRef.getLength());
            }
            parquetColumns.add(columnChunk);
        }
        RowGroup rowGroup = new RowGroup(parquetColumns, block.getTotalByteSize(), block.getRowCount());
        rowGroup.setFile_offset(block.getStartingPos());
        rowGroup.setTotal_compressed_size(block.getCompressedSize());
        rowGroup.setOrdinal((short)rowGroupOrdinal);
        rowGroups.add(rowGroup);
    }

    private List<Encoding> toFormatEncodings(Set<org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding> encodings) {
        ArrayList<Encoding> converted = new ArrayList<Encoding>(encodings.size());
        for (org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding encoding : encodings) {
            converted.add(this.getEncoding(encoding));
        }
        return converted;
    }

    Set<org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding> fromFormatEncodings(List<Encoding> encodings) {
        Set<org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding> converted = new HashSet();
        for (Encoding encoding : encodings) {
            converted.add(this.getEncoding(encoding));
        }
        Set<org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding> cached = cachedEncodingSets.putIfAbsent(converted = Collections.unmodifiableSet(converted), converted);
        if (cached == null) {
            cached = converted;
        }
        return cached;
    }

    private CompressionCodecName fromFormatCodec(CompressionCodec codec) {
        return CompressionCodecName.valueOf(codec.toString());
    }

    private CompressionCodec toFormatCodec(CompressionCodecName codec) {
        return CompressionCodec.valueOf(codec.toString());
    }

    public org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding getEncoding(Encoding encoding) {
        return org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding.valueOf(encoding.name());
    }

    public Encoding getEncoding(org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding encoding) {
        return Encoding.valueOf(encoding.name());
    }

    public EncodingStats convertEncodingStats(List<PageEncodingStats> stats) {
        if (stats == null) {
            return null;
        }
        EncodingStats.Builder builder = new EncodingStats.Builder();
        for (PageEncodingStats stat : stats) {
            switch (stat.getPage_type()) {
                case DATA_PAGE_V2: {
                    builder.withV2Pages();
                }
                case DATA_PAGE: {
                    builder.addDataEncoding(this.getEncoding(stat.getEncoding()), stat.getCount());
                    break;
                }
                case DICTIONARY_PAGE: {
                    builder.addDictEncoding(this.getEncoding(stat.getEncoding()), stat.getCount());
                }
            }
        }
        return builder.build();
    }

    public List<PageEncodingStats> convertEncodingStats(EncodingStats stats) {
        if (stats == null) {
            return null;
        }
        ArrayList<PageEncodingStats> formatStats = new ArrayList<PageEncodingStats>();
        for (org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding encoding : stats.getDictionaryEncodings()) {
            formatStats.add(new PageEncodingStats(PageType.DICTIONARY_PAGE, this.getEncoding(encoding), stats.getNumDictionaryPagesEncodedAs(encoding)));
        }
        PageType dataPageType = stats.usesV2Pages() ? PageType.DATA_PAGE_V2 : PageType.DATA_PAGE;
        for (org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding encoding : stats.getDataEncodings()) {
            formatStats.add(new PageEncodingStats(dataPageType, this.getEncoding(encoding), stats.getNumDataPagesEncodedAs(encoding)));
        }
        return formatStats;
    }

    public static Statistics toParquetStatistics(org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics stats) {
        return ParquetMetadataConverter.toParquetStatistics(stats, Integer.MAX_VALUE);
    }

    public static Statistics toParquetStatistics(org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics stats, int truncateLength) {
        Statistics formatStats = new Statistics();
        if (!stats.isEmpty() && ParquetMetadataConverter.withinLimit(stats, truncateLength)) {
            formatStats.setNull_count(stats.getNumNulls());
            if (stats.hasNonNullValue()) {
                byte[] max;
                byte[] min;
                if (stats instanceof BinaryStatistics && truncateLength != Integer.MAX_VALUE) {
                    BinaryTruncator truncator = BinaryTruncator.getTruncator(stats.type());
                    min = ParquetMetadataConverter.tuncateMin(truncator, truncateLength, stats.getMinBytes());
                    max = ParquetMetadataConverter.tuncateMax(truncator, truncateLength, stats.getMaxBytes());
                } else {
                    min = stats.getMinBytes();
                    max = stats.getMaxBytes();
                }
                if (ParquetMetadataConverter.sortOrder(stats.type()) == SortOrder.SIGNED || Arrays.equals(min, max)) {
                    formatStats.setMin(min);
                    formatStats.setMax(max);
                }
                if (ParquetMetadataConverter.isMinMaxStatsSupported(stats.type()) || Arrays.equals(min, max)) {
                    formatStats.setMin_value(min);
                    formatStats.setMax_value(max);
                }
            }
        }
        return formatStats;
    }

    private static boolean withinLimit(org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics stats, int truncateLength) {
        if (stats.isSmallerThan(4096L)) {
            return true;
        }
        if (!(stats instanceof BinaryStatistics)) {
            return false;
        }
        BinaryStatistics binaryStatistics = (BinaryStatistics)stats;
        return binaryStatistics.isSmallerThanWithTruncation(4096L, truncateLength);
    }

    private static byte[] tuncateMin(BinaryTruncator truncator, int truncateLength, byte[] input) {
        return truncator.truncateMin(Binary.fromConstantByteArray(input), truncateLength).getBytes();
    }

    private static byte[] tuncateMax(BinaryTruncator truncator, int truncateLength, byte[] input) {
        return truncator.truncateMax(Binary.fromConstantByteArray(input), truncateLength).getBytes();
    }

    private static boolean isMinMaxStatsSupported(PrimitiveType type) {
        return type.columnOrder().getColumnOrderName() == ColumnOrder.ColumnOrderName.TYPE_DEFINED_ORDER;
    }

    @Deprecated
    public static org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics fromParquetStatistics(Statistics statistics, PrimitiveType.PrimitiveTypeName type) {
        return ParquetMetadataConverter.fromParquetStatistics(null, statistics, type);
    }

    @Deprecated
    public static org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics fromParquetStatistics(String createdBy, Statistics statistics, PrimitiveType.PrimitiveTypeName type) {
        return ParquetMetadataConverter.fromParquetStatisticsInternal(createdBy, statistics, new PrimitiveType(Type.Repetition.OPTIONAL, type, "fake_type"), ParquetMetadataConverter.defaultSortOrder(type));
    }

    static org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics fromParquetStatisticsInternal(String createdBy, Statistics formatStats, PrimitiveType type, SortOrder typeSortOrder) {
        Statistics.Builder statsBuilder = org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics.getBuilderForReading(type);
        if (formatStats != null) {
            if (formatStats.isSetMin_value() && formatStats.isSetMax_value()) {
                byte[] min = formatStats.min_value.array();
                byte[] max = formatStats.max_value.array();
                if (ParquetMetadataConverter.isMinMaxStatsSupported(type) || Arrays.equals(min, max)) {
                    statsBuilder.withMin(min);
                    statsBuilder.withMax(max);
                }
            } else {
                boolean sortOrdersMatch;
                boolean isSet = formatStats.isSetMax() && formatStats.isSetMin();
                boolean maxEqualsMin = isSet ? Arrays.equals(formatStats.getMin(), formatStats.getMax()) : false;
                boolean bl = sortOrdersMatch = SortOrder.SIGNED == typeSortOrder;
                if (!CorruptStatistics.shouldIgnoreStatistics(createdBy, type.getPrimitiveTypeName()) && (sortOrdersMatch || maxEqualsMin) && isSet) {
                    statsBuilder.withMin(formatStats.min.array());
                    statsBuilder.withMax(formatStats.max.array());
                }
            }
            if (formatStats.isSetNull_count()) {
                statsBuilder.withNumNulls(formatStats.null_count);
            }
        }
        return statsBuilder.build();
    }

    public org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics fromParquetStatistics(String createdBy, Statistics statistics, PrimitiveType type) {
        SortOrder expectedOrder = this.overrideSortOrderToSigned(type) ? SortOrder.SIGNED : ParquetMetadataConverter.sortOrder(type);
        return ParquetMetadataConverter.fromParquetStatisticsInternal(createdBy, statistics, type, expectedOrder);
    }

    private boolean overrideSortOrderToSigned(PrimitiveType type) {
        LogicalTypeAnnotation annotation = type.getLogicalTypeAnnotation();
        return this.useSignedStringMinMax && PrimitiveType.PrimitiveTypeName.BINARY == type.getPrimitiveTypeName() && (annotation == null || STRING_TYPES.contains(annotation.getClass()));
    }

    private static SortOrder defaultSortOrder(PrimitiveType.PrimitiveTypeName primitive) {
        switch (primitive) {
            case BOOLEAN: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: {
                return SortOrder.SIGNED;
            }
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                return SortOrder.UNSIGNED;
            }
        }
        return SortOrder.UNKNOWN;
    }

    private static SortOrder sortOrder(PrimitiveType primitive) {
        LogicalTypeAnnotation annotation = primitive.getLogicalTypeAnnotation();
        if (annotation != null) {
            return annotation.accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<SortOrder>(){

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
                    return intLogicalType.isSigned() ? Optional.of(SortOrder.SIGNED) : Optional.of(SortOrder.UNSIGNED);
                }

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation intervalLogicalType) {
                    return Optional.of(SortOrder.UNKNOWN);
                }

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
                    return Optional.of(SortOrder.SIGNED);
                }

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
                    return Optional.of(SortOrder.UNSIGNED);
                }

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonLogicalType) {
                    return Optional.of(SortOrder.UNSIGNED);
                }

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidLogicalType) {
                    return Optional.of(SortOrder.UNSIGNED);
                }

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
                    return Optional.of(SortOrder.UNSIGNED);
                }

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                    return Optional.of(SortOrder.UNSIGNED);
                }

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                    return Optional.of(SortOrder.UNKNOWN);
                }

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.MapKeyValueTypeAnnotation mapKeyValueLogicalType) {
                    return Optional.of(SortOrder.UNKNOWN);
                }

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation mapLogicalType) {
                    return Optional.of(SortOrder.UNKNOWN);
                }

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation listLogicalType) {
                    return Optional.of(SortOrder.UNKNOWN);
                }

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
                    return Optional.of(SortOrder.SIGNED);
                }

                @Override
                public Optional<SortOrder> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
                    return Optional.of(SortOrder.SIGNED);
                }
            }).orElse(ParquetMetadataConverter.defaultSortOrder(primitive.getPrimitiveTypeName()));
        }
        return ParquetMetadataConverter.defaultSortOrder(primitive.getPrimitiveTypeName());
    }

    public PrimitiveType.PrimitiveTypeName getPrimitive(Type type) {
        switch (type) {
            case BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.BINARY;
            }
            case INT64: {
                return PrimitiveType.PrimitiveTypeName.INT64;
            }
            case INT32: {
                return PrimitiveType.PrimitiveTypeName.INT32;
            }
            case BOOLEAN: {
                return PrimitiveType.PrimitiveTypeName.BOOLEAN;
            }
            case FLOAT: {
                return PrimitiveType.PrimitiveTypeName.FLOAT;
            }
            case DOUBLE: {
                return PrimitiveType.PrimitiveTypeName.DOUBLE;
            }
            case INT96: {
                return PrimitiveType.PrimitiveTypeName.INT96;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
            }
        }
        throw new RuntimeException("Unknown type " + type);
    }

    Type getType(PrimitiveType.PrimitiveTypeName type) {
        switch (type) {
            case INT64: {
                return Type.INT64;
            }
            case INT32: {
                return Type.INT32;
            }
            case BOOLEAN: {
                return Type.BOOLEAN;
            }
            case BINARY: {
                return Type.BYTE_ARRAY;
            }
            case FLOAT: {
                return Type.FLOAT;
            }
            case DOUBLE: {
                return Type.DOUBLE;
            }
            case INT96: {
                return Type.INT96;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return Type.FIXED_LEN_BYTE_ARRAY;
            }
        }
        throw new RuntimeException("Unknown primitive type " + (Object)((Object)type));
    }

    LogicalTypeAnnotation getLogicalTypeAnnotation(ConvertedType type, SchemaElement schemaElement) {
        switch (type) {
            case UTF8: {
                return LogicalTypeAnnotation.stringType();
            }
            case MAP: {
                return LogicalTypeAnnotation.mapType();
            }
            case MAP_KEY_VALUE: {
                return LogicalTypeAnnotation.MapKeyValueTypeAnnotation.getInstance();
            }
            case LIST: {
                return LogicalTypeAnnotation.listType();
            }
            case ENUM: {
                return LogicalTypeAnnotation.enumType();
            }
            case DECIMAL: {
                int scale = schemaElement == null ? 0 : schemaElement.scale;
                int precision = schemaElement == null ? 0 : schemaElement.precision;
                return LogicalTypeAnnotation.decimalType(scale, precision);
            }
            case DATE: {
                return LogicalTypeAnnotation.dateType();
            }
            case TIME_MILLIS: {
                return LogicalTypeAnnotation.timeType(true, LogicalTypeAnnotation.TimeUnit.MILLIS);
            }
            case TIME_MICROS: {
                return LogicalTypeAnnotation.timeType(true, LogicalTypeAnnotation.TimeUnit.MICROS);
            }
            case TIMESTAMP_MILLIS: {
                return LogicalTypeAnnotation.timestampType(true, LogicalTypeAnnotation.TimeUnit.MILLIS);
            }
            case TIMESTAMP_MICROS: {
                return LogicalTypeAnnotation.timestampType(true, LogicalTypeAnnotation.TimeUnit.MICROS);
            }
            case INTERVAL: {
                return LogicalTypeAnnotation.IntervalLogicalTypeAnnotation.getInstance();
            }
            case INT_8: {
                return LogicalTypeAnnotation.intType(8, true);
            }
            case INT_16: {
                return LogicalTypeAnnotation.intType(16, true);
            }
            case INT_32: {
                return LogicalTypeAnnotation.intType(32, true);
            }
            case INT_64: {
                return LogicalTypeAnnotation.intType(64, true);
            }
            case UINT_8: {
                return LogicalTypeAnnotation.intType(8, false);
            }
            case UINT_16: {
                return LogicalTypeAnnotation.intType(16, false);
            }
            case UINT_32: {
                return LogicalTypeAnnotation.intType(32, false);
            }
            case UINT_64: {
                return LogicalTypeAnnotation.intType(64, false);
            }
            case JSON: {
                return LogicalTypeAnnotation.jsonType();
            }
            case BSON: {
                return LogicalTypeAnnotation.bsonType();
            }
        }
        throw new RuntimeException("Can't convert converted type to logical type, unknown converted type " + type);
    }

    LogicalTypeAnnotation getLogicalTypeAnnotation(LogicalType type) {
        switch ((LogicalType._Fields)type.getSetField()) {
            case MAP: {
                return LogicalTypeAnnotation.mapType();
            }
            case BSON: {
                return LogicalTypeAnnotation.bsonType();
            }
            case DATE: {
                return LogicalTypeAnnotation.dateType();
            }
            case ENUM: {
                return LogicalTypeAnnotation.enumType();
            }
            case JSON: {
                return LogicalTypeAnnotation.jsonType();
            }
            case LIST: {
                return LogicalTypeAnnotation.listType();
            }
            case TIME: {
                TimeType time = type.getTIME();
                return LogicalTypeAnnotation.timeType(time.isAdjustedToUTC, this.convertTimeUnit(time.unit));
            }
            case STRING: {
                return LogicalTypeAnnotation.stringType();
            }
            case DECIMAL: {
                DecimalType decimal = type.getDECIMAL();
                return LogicalTypeAnnotation.decimalType(decimal.scale, decimal.precision);
            }
            case INTEGER: {
                IntType integer = type.getINTEGER();
                return LogicalTypeAnnotation.intType(integer.bitWidth, integer.isSigned);
            }
            case UNKNOWN: {
                return null;
            }
            case TIMESTAMP: {
                TimestampType timestamp = type.getTIMESTAMP();
                return LogicalTypeAnnotation.timestampType(timestamp.isAdjustedToUTC, this.convertTimeUnit(timestamp.unit));
            }
            case UUID: {
                return LogicalTypeAnnotation.uuidType();
            }
        }
        throw new RuntimeException("Unknown logical type " + type);
    }

    private LogicalTypeAnnotation.TimeUnit convertTimeUnit(TimeUnit unit) {
        switch ((TimeUnit._Fields)unit.getSetField()) {
            case MICROS: {
                return LogicalTypeAnnotation.TimeUnit.MICROS;
            }
            case MILLIS: {
                return LogicalTypeAnnotation.TimeUnit.MILLIS;
            }
            case NANOS: {
                return LogicalTypeAnnotation.TimeUnit.NANOS;
            }
        }
        throw new RuntimeException("Unknown time unit " + unit);
    }

    private static void addKeyValue(FileMetaData fileMetaData, String key, String value) {
        KeyValue keyValue = new KeyValue(key);
        keyValue.value = value;
        fileMetaData.addToKey_value_metadata(keyValue);
    }

    public static MetadataFilter range(long startOffset, long endOffset) {
        return new RangeMetadataFilter(startOffset, endOffset);
    }

    public static MetadataFilter offsets(long ... offsets) {
        HashSet<Long> set = new HashSet<Long>();
        for (long offset : offsets) {
            set.add(offset);
        }
        return new OffsetMetadataFilter(set);
    }

    @Deprecated
    public ParquetMetadata readParquetMetadata(InputStream from) throws IOException {
        return this.readParquetMetadata(from, NO_FILTER);
    }

    static FileMetaData filterFileMetaDataByMidpoint(FileMetaData metaData, RangeMetadataFilter filter) {
        List<RowGroup> rowGroups = metaData.getRow_groups();
        ArrayList<RowGroup> newRowGroups = new ArrayList<RowGroup>();
        long preStartIndex = 0L;
        long preCompressedSize = 0L;
        boolean firstColumnWithMetadata = true;
        if (rowGroups != null && rowGroups.size() > 0) {
            firstColumnWithMetadata = rowGroups.get(0).getColumns().get(0).isSetMeta_data();
        }
        for (RowGroup rowGroup : rowGroups) {
            long midPoint;
            long startIndex;
            long totalSize = 0L;
            ColumnChunk columnChunk = rowGroup.getColumns().get(0);
            if (firstColumnWithMetadata) {
                startIndex = ParquetMetadataConverter.getOffset(columnChunk);
            } else {
                assert (rowGroup.isSetFile_offset());
                assert (rowGroup.isSetTotal_compressed_size());
                startIndex = rowGroup.getFile_offset();
                if (ParquetMetadataConverter.invalidFileOffset(startIndex, preStartIndex, preCompressedSize)) {
                    startIndex = preStartIndex == 0L ? 4L : preStartIndex + preCompressedSize;
                }
                preStartIndex = startIndex;
                preCompressedSize = rowGroup.getTotal_compressed_size();
            }
            if (rowGroup.isSetTotal_compressed_size()) {
                totalSize = rowGroup.getTotal_compressed_size();
            } else {
                for (ColumnChunk col : rowGroup.getColumns()) {
                    totalSize += col.getMeta_data().getTotal_compressed_size();
                }
            }
            if (!filter.contains(midPoint = startIndex + totalSize / 2L)) continue;
            newRowGroups.add(rowGroup);
        }
        metaData.setRow_groups(newRowGroups);
        return metaData;
    }

    private static boolean invalidFileOffset(long startIndex, long preStartIndex, long preCompressedSize) {
        boolean invalid = false;
        assert (preStartIndex <= startIndex);
        if (preStartIndex == 0L && startIndex != 4L) {
            invalid = true;
            return invalid;
        }
        long minStartIndex = preStartIndex + preCompressedSize;
        if (startIndex < minStartIndex) {
            invalid = true;
        }
        return invalid;
    }

    static FileMetaData filterFileMetaDataByStart(FileMetaData metaData, OffsetMetadataFilter filter) {
        List<RowGroup> rowGroups = metaData.getRow_groups();
        ArrayList<RowGroup> newRowGroups = new ArrayList<RowGroup>();
        long preStartIndex = 0L;
        long preCompressedSize = 0L;
        boolean firstColumnWithMetadata = true;
        if (rowGroups != null && rowGroups.size() > 0) {
            firstColumnWithMetadata = rowGroups.get(0).getColumns().get(0).isSetMeta_data();
        }
        for (RowGroup rowGroup : rowGroups) {
            long startIndex;
            ColumnChunk columnChunk = rowGroup.getColumns().get(0);
            if (firstColumnWithMetadata) {
                startIndex = ParquetMetadataConverter.getOffset(columnChunk);
            } else {
                assert (rowGroup.isSetFile_offset());
                assert (rowGroup.isSetTotal_compressed_size());
                startIndex = rowGroup.getFile_offset();
                if (ParquetMetadataConverter.invalidFileOffset(startIndex, preStartIndex, preCompressedSize)) {
                    if (preStartIndex == 0L) {
                        startIndex = 4L;
                    } else {
                        throw new InvalidFileOffsetException("corrupted RowGroup.file_offset found, please use file range instead of block offset for split.");
                    }
                }
                preStartIndex = startIndex;
                preCompressedSize = rowGroup.getTotal_compressed_size();
            }
            if (!filter.contains(startIndex)) continue;
            newRowGroups.add(rowGroup);
        }
        metaData.setRow_groups(newRowGroups);
        return metaData;
    }

    static long getOffset(RowGroup rowGroup) {
        if (rowGroup.isSetFile_offset()) {
            return rowGroup.getFile_offset();
        }
        return ParquetMetadataConverter.getOffset(rowGroup.getColumns().get(0));
    }

    static long getOffset(ColumnChunk columnChunk) {
        ColumnMetaData md = columnChunk.getMeta_data();
        long offset = md.getData_page_offset();
        if (md.isSetDictionary_page_offset() && offset > md.getDictionary_page_offset()) {
            offset = md.getDictionary_page_offset();
        }
        return offset;
    }

    private static void verifyFooterIntegrity(InputStream from, InternalFileDecryptor fileDecryptor, int combinedFooterLength) throws IOException {
        byte[] nonce = new byte[12];
        from.read(nonce);
        byte[] gcmTag = new byte[16];
        from.read(gcmTag);
        AesGcmEncryptor footerSigner = fileDecryptor.createSignedFooterEncryptor();
        byte[] footerAndSignature = ((ByteBufferInputStream)from).slice(0).array();
        int footerSignatureLength = 28;
        byte[] serializedFooter = new byte[combinedFooterLength - footerSignatureLength];
        System.arraycopy(footerAndSignature, 0, serializedFooter, 0, serializedFooter.length);
        byte[] signedFooterAAD = AesCipher.createFooterAAD(fileDecryptor.getFileAAD());
        byte[] encryptedFooterBytes = footerSigner.encrypt(false, serializedFooter, nonce, signedFooterAAD);
        byte[] calculatedTag = new byte[16];
        System.arraycopy(encryptedFooterBytes, encryptedFooterBytes.length - 16, calculatedTag, 0, 16);
        if (!Arrays.equals(gcmTag, calculatedTag)) {
            throw new TagVerificationException("Signature mismatch in plaintext footer");
        }
    }

    public ParquetMetadata readParquetMetadata(InputStream from, MetadataFilter filter) throws IOException {
        return this.readParquetMetadata(from, filter, null, false, 0);
    }

    public ParquetMetadata readParquetMetadata(final InputStream from, MetadataFilter filter, InternalFileDecryptor fileDecryptor, boolean encryptedFooter, int combinedFooterLength) throws IOException {
        final BlockCipher.Decryptor footerDecryptor = encryptedFooter ? fileDecryptor.fetchFooterDecryptor() : null;
        final byte[] encryptedFooterAAD = encryptedFooter ? AesCipher.createFooterAAD(fileDecryptor.getFileAAD()) : null;
        FileMetaData fileMetaData = filter.accept(new MetadataFilterVisitor<FileMetaData, IOException>(){

            @Override
            public FileMetaData visit(NoFilter filter) throws IOException {
                return Util.readFileMetaData(from, footerDecryptor, encryptedFooterAAD);
            }

            @Override
            public FileMetaData visit(SkipMetadataFilter filter) throws IOException {
                return Util.readFileMetaData(from, true, footerDecryptor, encryptedFooterAAD);
            }

            @Override
            public FileMetaData visit(OffsetMetadataFilter filter) throws IOException {
                return ParquetMetadataConverter.filterFileMetaDataByStart(Util.readFileMetaData(from, footerDecryptor, encryptedFooterAAD), filter);
            }

            @Override
            public FileMetaData visit(RangeMetadataFilter filter) throws IOException {
                return ParquetMetadataConverter.filterFileMetaDataByMidpoint(Util.readFileMetaData(from, footerDecryptor, encryptedFooterAAD), filter);
            }
        });
        LOG.debug("{}", (Object)fileMetaData);
        if (!encryptedFooter && null != fileDecryptor) {
            if (!fileMetaData.isSetEncryption_algorithm()) {
                fileDecryptor.setPlaintextFile();
                if (!fileDecryptor.plaintextFilesAllowed()) {
                    throw new ParquetCryptoRuntimeException("Applying decryptor on plaintext file");
                }
            } else {
                fileDecryptor.setFileCryptoMetaData(fileMetaData.getEncryption_algorithm(), false, fileMetaData.getFooter_signing_key_metadata());
                if (fileDecryptor.checkFooterIntegrity()) {
                    ParquetMetadataConverter.verifyFooterIntegrity(from, fileDecryptor, combinedFooterLength);
                }
            }
        }
        ParquetMetadata parquetMetadata = this.fromParquetMetadata(fileMetaData, fileDecryptor, encryptedFooter);
        if (LOG.isDebugEnabled()) {
            LOG.debug(ParquetMetadata.toPrettyJSON(parquetMetadata));
        }
        return parquetMetadata;
    }

    public ColumnChunkMetaData buildColumnChunkMetaData(ColumnMetaData metaData, ColumnPath columnPath, PrimitiveType type, String createdBy) {
        return ColumnChunkMetaData.get(columnPath, type, this.fromFormatCodec(metaData.codec), this.convertEncodingStats(metaData.getEncoding_stats()), this.fromFormatEncodings(metaData.encodings), this.fromParquetStatistics(createdBy, metaData.statistics, type), metaData.data_page_offset, metaData.dictionary_page_offset, metaData.num_values, metaData.total_compressed_size, metaData.total_uncompressed_size);
    }

    public ParquetMetadata fromParquetMetadata(FileMetaData parquetMetadata) throws IOException {
        return this.fromParquetMetadata(parquetMetadata, null, false);
    }

    public ParquetMetadata fromParquetMetadata(FileMetaData parquetMetadata, InternalFileDecryptor fileDecryptor, boolean encryptedFooter) throws IOException {
        MessageType messageType = this.fromParquetSchema(parquetMetadata.getSchema(), parquetMetadata.getColumn_orders());
        ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
        List<RowGroup> row_groups = parquetMetadata.getRow_groups();
        if (row_groups != null) {
            for (RowGroup rowGroup : row_groups) {
                BlockMetaData blockMetaData = new BlockMetaData();
                blockMetaData.setRowCount(rowGroup.getNum_rows());
                blockMetaData.setTotalByteSize(rowGroup.getTotal_byte_size());
                if (rowGroup.isSetOrdinal()) {
                    blockMetaData.setOrdinal(rowGroup.getOrdinal());
                }
                List<ColumnChunk> columns = rowGroup.getColumns();
                String filePath = columns.get(0).getFile_path();
                int columnOrdinal = -1;
                for (ColumnChunk columnChunk : columns) {
                    ++columnOrdinal;
                    if (filePath == null && columnChunk.getFile_path() != null || filePath != null && !filePath.equals(columnChunk.getFile_path())) {
                        throw new ParquetDecodingException("all column chunks of the same row group must be in the same file for now");
                    }
                    ColumnMetaData metaData = columnChunk.meta_data;
                    ColumnCryptoMetaData cryptoMetaData = columnChunk.getCrypto_metadata();
                    ColumnChunkMetaData column = null;
                    ColumnPath columnPath = null;
                    boolean encryptedMetadata = false;
                    if (null == cryptoMetaData) {
                        columnPath = ParquetMetadataConverter.getPath(metaData);
                        if (null != fileDecryptor && !fileDecryptor.plaintextFile()) {
                            fileDecryptor.setColumnCryptoMetadata(columnPath, false, false, null, columnOrdinal);
                        }
                    } else {
                        boolean encryptedWithFooterKey = cryptoMetaData.isSetENCRYPTION_WITH_FOOTER_KEY();
                        if (encryptedWithFooterKey) {
                            if (!encryptedFooter) {
                                throw new ParquetCryptoRuntimeException("Column encrypted with footer key in file with plaintext footer");
                            }
                            if (null == metaData) {
                                throw new ParquetCryptoRuntimeException("ColumnMetaData not set in Encryption with Footer key");
                            }
                            if (null == fileDecryptor) {
                                throw new ParquetCryptoRuntimeException("Column encrypted with footer key: No keys available");
                            }
                            columnPath = ParquetMetadataConverter.getPath(metaData);
                            fileDecryptor.setColumnCryptoMetadata(columnPath, true, true, null, columnOrdinal);
                        } else {
                            encryptedMetadata = true;
                        }
                    }
                    String createdBy = parquetMetadata.getCreated_by();
                    if (!encryptedMetadata) {
                        column = this.buildColumnChunkMetaData(metaData, columnPath, messageType.getType(columnPath.toArray()).asPrimitiveType(), createdBy);
                        column.setRowGroupOrdinal(rowGroup.getOrdinal());
                        if (metaData.isSetBloom_filter_offset()) {
                            column.setBloomFilterOffset(metaData.getBloom_filter_offset());
                        }
                    } else {
                        EncryptionWithColumnKey columnKeyStruct = cryptoMetaData.getENCRYPTION_WITH_COLUMN_KEY();
                        List<String> pathList = columnKeyStruct.getPath_in_schema();
                        byte[] columnKeyMetadata = columnKeyStruct.getKey_metadata();
                        columnPath = ColumnPath.get(pathList.toArray(new String[pathList.size()]));
                        byte[] encryptedMetadataBuffer = columnChunk.getEncrypted_column_metadata();
                        column = ColumnChunkMetaData.getWithEncryptedMetadata(this, columnPath, messageType.getType(columnPath.toArray()).asPrimitiveType(), encryptedMetadataBuffer, columnKeyMetadata, fileDecryptor, rowGroup.getOrdinal(), columnOrdinal, createdBy);
                    }
                    column.setColumnIndexReference(ParquetMetadataConverter.toColumnIndexReference(columnChunk));
                    column.setOffsetIndexReference(ParquetMetadataConverter.toOffsetIndexReference(columnChunk));
                    blockMetaData.addColumn(column);
                }
                blockMetaData.setPath(filePath);
                blocks.add(blockMetaData);
            }
        }
        HashMap<String, String> keyValueMetaData = new HashMap<String, String>();
        List<KeyValue> key_value_metadata = parquetMetadata.getKey_value_metadata();
        if (key_value_metadata != null) {
            for (KeyValue keyValue : key_value_metadata) {
                keyValueMetaData.put(keyValue.key, keyValue.value);
            }
        }
        return new ParquetMetadata(new org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.FileMetaData(messageType, keyValueMetaData, parquetMetadata.getCreated_by(), fileDecryptor), blocks);
    }

    private static IndexReference toColumnIndexReference(ColumnChunk columnChunk) {
        if (columnChunk.isSetColumn_index_offset() && columnChunk.isSetColumn_index_length()) {
            return new IndexReference(columnChunk.getColumn_index_offset(), columnChunk.getColumn_index_length());
        }
        return null;
    }

    private static IndexReference toOffsetIndexReference(ColumnChunk columnChunk) {
        if (columnChunk.isSetOffset_index_offset() && columnChunk.isSetOffset_index_length()) {
            return new IndexReference(columnChunk.getOffset_index_offset(), columnChunk.getOffset_index_length());
        }
        return null;
    }

    private static ColumnPath getPath(ColumnMetaData metaData) {
        String[] path = metaData.path_in_schema.toArray(new String[0]);
        return ColumnPath.get(path);
    }

    MessageType fromParquetSchema(List<SchemaElement> schema, List<ColumnOrder> columnOrders) {
        Iterator<SchemaElement> iterator = schema.iterator();
        SchemaElement root = iterator.next();
        Types.MessageTypeBuilder builder = Types.buildMessage();
        if (root.isSetField_id()) {
            builder.id(root.field_id);
        }
        this.buildChildren(builder, iterator, root.getNum_children(), columnOrders, 0);
        return builder.named(root.name);
    }

    private void buildChildren(Types.GroupBuilder builder, Iterator<SchemaElement> schema, int childrenCount, List<ColumnOrder> columnOrders, int columnCount) {
        for (int i = 0; i < childrenCount; ++i) {
            Types.Builder childBuilder;
            SchemaElement schemaElement = schema.next();
            if (schemaElement.type != null) {
                Types.PrimitiveBuilder primitiveBuilder = builder.primitive(this.getPrimitive(schemaElement.type), this.fromParquetRepetition(schemaElement.repetition_type));
                if (schemaElement.isSetType_length()) {
                    primitiveBuilder.length(schemaElement.type_length);
                }
                if (schemaElement.isSetPrecision()) {
                    primitiveBuilder.precision(schemaElement.precision);
                }
                if (schemaElement.isSetScale()) {
                    primitiveBuilder.scale(schemaElement.scale);
                }
                if (columnOrders != null) {
                    org.apache.flink.table.store.shaded.org.apache.parquet.schema.ColumnOrder columnOrder = ParquetMetadataConverter.fromParquetColumnOrder(columnOrders.get(columnCount));
                    if (columnOrder.getColumnOrderName() == ColumnOrder.ColumnOrderName.TYPE_DEFINED_ORDER && (schemaElement.type == Type.INT96 || schemaElement.converted_type == ConvertedType.INTERVAL)) {
                        columnOrder = org.apache.flink.table.store.shaded.org.apache.parquet.schema.ColumnOrder.undefined();
                    }
                    primitiveBuilder.columnOrder(columnOrder);
                }
                childBuilder = primitiveBuilder;
            } else {
                childBuilder = builder.group(this.fromParquetRepetition(schemaElement.repetition_type));
                this.buildChildren((Types.GroupBuilder)childBuilder, schema, schemaElement.num_children, columnOrders, columnCount);
            }
            if (schemaElement.isSetLogicalType()) {
                childBuilder.as(this.getLogicalTypeAnnotation(schemaElement.logicalType));
            }
            if (schemaElement.isSetConverted_type()) {
                OriginalType newOriginalType;
                OriginalType originalType = this.getLogicalTypeAnnotation(schemaElement.converted_type, schemaElement).toOriginalType();
                OriginalType originalType2 = newOriginalType = schemaElement.isSetLogicalType() && this.getLogicalTypeAnnotation(schemaElement.logicalType) != null ? this.getLogicalTypeAnnotation(schemaElement.logicalType).toOriginalType() : null;
                if (!originalType.equals((Object)newOriginalType)) {
                    if (newOriginalType != null) {
                        LOG.warn("Converted type and logical type metadata mismatch (convertedType: {}, logical type: {}). Using value in converted type.", (Object)schemaElement.converted_type, (Object)schemaElement.logicalType);
                    }
                    childBuilder.as(originalType);
                }
            }
            if (schemaElement.isSetField_id()) {
                childBuilder.id(schemaElement.field_id);
            }
            childBuilder.named(schemaElement.name);
            ++columnCount;
        }
    }

    FieldRepetitionType toParquetRepetition(Type.Repetition repetition) {
        return FieldRepetitionType.valueOf(repetition.name());
    }

    Type.Repetition fromParquetRepetition(FieldRepetitionType repetition) {
        return Type.Repetition.valueOf(repetition.name());
    }

    private static org.apache.flink.table.store.shaded.org.apache.parquet.schema.ColumnOrder fromParquetColumnOrder(ColumnOrder columnOrder) {
        if (columnOrder.isSetTYPE_ORDER()) {
            return org.apache.flink.table.store.shaded.org.apache.parquet.schema.ColumnOrder.typeDefined();
        }
        return org.apache.flink.table.store.shaded.org.apache.parquet.schema.ColumnOrder.undefined();
    }

    @Deprecated
    public void writeDataPageHeader(int uncompressedSize, int compressedSize, int valueCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding rlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding dlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding valuesEncoding, OutputStream to) throws IOException {
        Util.writePageHeader(this.newDataPageHeader(uncompressedSize, compressedSize, valueCount, rlEncoding, dlEncoding, valuesEncoding), to);
    }

    @Deprecated
    public void writeDataPageHeader(int uncompressedSize, int compressedSize, int valueCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics statistics, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding rlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding dlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding valuesEncoding, OutputStream to) throws IOException {
        Util.writePageHeader(this.newDataPageHeader(uncompressedSize, compressedSize, valueCount, rlEncoding, dlEncoding, valuesEncoding), to);
    }

    private PageHeader newDataPageHeader(int uncompressedSize, int compressedSize, int valueCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding rlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding dlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding valuesEncoding) {
        PageHeader pageHeader = new PageHeader(PageType.DATA_PAGE, uncompressedSize, compressedSize);
        pageHeader.setData_page_header(new DataPageHeader(valueCount, this.getEncoding(valuesEncoding), this.getEncoding(dlEncoding), this.getEncoding(rlEncoding)));
        return pageHeader;
    }

    private PageHeader newDataPageHeader(int uncompressedSize, int compressedSize, int valueCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding rlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding dlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding valuesEncoding, int crc) {
        PageHeader pageHeader = new PageHeader(PageType.DATA_PAGE, uncompressedSize, compressedSize);
        pageHeader.setCrc(crc);
        pageHeader.setData_page_header(new DataPageHeader(valueCount, this.getEncoding(valuesEncoding), this.getEncoding(dlEncoding), this.getEncoding(rlEncoding)));
        return pageHeader;
    }

    @Deprecated
    public void writeDataPageV2Header(int uncompressedSize, int compressedSize, int valueCount, int nullCount, int rowCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics statistics, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding dataEncoding, int rlByteLength, int dlByteLength, OutputStream to) throws IOException {
        Util.writePageHeader(this.newDataPageV2Header(uncompressedSize, compressedSize, valueCount, nullCount, rowCount, dataEncoding, rlByteLength, dlByteLength), to);
    }

    public void writeDataPageV1Header(int uncompressedSize, int compressedSize, int valueCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding rlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding dlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding valuesEncoding, OutputStream to) throws IOException {
        this.writeDataPageV1Header(uncompressedSize, compressedSize, valueCount, rlEncoding, dlEncoding, valuesEncoding, to, null, null);
    }

    public void writeDataPageV1Header(int uncompressedSize, int compressedSize, int valueCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding rlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding dlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding valuesEncoding, OutputStream to, BlockCipher.Encryptor blockEncryptor, byte[] AAD) throws IOException {
        Util.writePageHeader(this.newDataPageHeader(uncompressedSize, compressedSize, valueCount, rlEncoding, dlEncoding, valuesEncoding), to, blockEncryptor, AAD);
    }

    public void writeDataPageV1Header(int uncompressedSize, int compressedSize, int valueCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding rlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding dlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding valuesEncoding, int crc, OutputStream to) throws IOException {
        this.writeDataPageV1Header(uncompressedSize, compressedSize, valueCount, rlEncoding, dlEncoding, valuesEncoding, crc, to, null, null);
    }

    public void writeDataPageV1Header(int uncompressedSize, int compressedSize, int valueCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding rlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding dlEncoding, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding valuesEncoding, int crc, OutputStream to, BlockCipher.Encryptor blockEncryptor, byte[] AAD) throws IOException {
        Util.writePageHeader(this.newDataPageHeader(uncompressedSize, compressedSize, valueCount, rlEncoding, dlEncoding, valuesEncoding, crc), to, blockEncryptor, AAD);
    }

    public void writeDataPageV2Header(int uncompressedSize, int compressedSize, int valueCount, int nullCount, int rowCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding dataEncoding, int rlByteLength, int dlByteLength, OutputStream to) throws IOException {
        this.writeDataPageV2Header(uncompressedSize, compressedSize, valueCount, nullCount, rowCount, dataEncoding, rlByteLength, dlByteLength, to, null, null);
    }

    public void writeDataPageV2Header(int uncompressedSize, int compressedSize, int valueCount, int nullCount, int rowCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding dataEncoding, int rlByteLength, int dlByteLength, OutputStream to, BlockCipher.Encryptor blockEncryptor, byte[] AAD) throws IOException {
        Util.writePageHeader(this.newDataPageV2Header(uncompressedSize, compressedSize, valueCount, nullCount, rowCount, dataEncoding, rlByteLength, dlByteLength), to, blockEncryptor, AAD);
    }

    private PageHeader newDataPageV2Header(int uncompressedSize, int compressedSize, int valueCount, int nullCount, int rowCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding dataEncoding, int rlByteLength, int dlByteLength) {
        DataPageHeaderV2 dataPageHeaderV2 = new DataPageHeaderV2(valueCount, nullCount, rowCount, this.getEncoding(dataEncoding), dlByteLength, rlByteLength);
        PageHeader pageHeader = new PageHeader(PageType.DATA_PAGE_V2, uncompressedSize, compressedSize);
        pageHeader.setData_page_header_v2(dataPageHeaderV2);
        return pageHeader;
    }

    public void writeDictionaryPageHeader(int uncompressedSize, int compressedSize, int valueCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding valuesEncoding, OutputStream to) throws IOException {
        this.writeDictionaryPageHeader(uncompressedSize, compressedSize, valueCount, valuesEncoding, to, null, null);
    }

    public void writeDictionaryPageHeader(int uncompressedSize, int compressedSize, int valueCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding valuesEncoding, OutputStream to, BlockCipher.Encryptor blockEncryptor, byte[] AAD) throws IOException {
        PageHeader pageHeader = new PageHeader(PageType.DICTIONARY_PAGE, uncompressedSize, compressedSize);
        pageHeader.setDictionary_page_header(new DictionaryPageHeader(valueCount, this.getEncoding(valuesEncoding)));
        Util.writePageHeader(pageHeader, to, blockEncryptor, AAD);
    }

    public void writeDictionaryPageHeader(int uncompressedSize, int compressedSize, int valueCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding valuesEncoding, int crc, OutputStream to) throws IOException {
        this.writeDictionaryPageHeader(uncompressedSize, compressedSize, valueCount, valuesEncoding, crc, to, null, null);
    }

    public void writeDictionaryPageHeader(int uncompressedSize, int compressedSize, int valueCount, org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding valuesEncoding, int crc, OutputStream to, BlockCipher.Encryptor blockEncryptor, byte[] AAD) throws IOException {
        PageHeader pageHeader = new PageHeader(PageType.DICTIONARY_PAGE, uncompressedSize, compressedSize);
        pageHeader.setCrc(crc);
        pageHeader.setDictionary_page_header(new DictionaryPageHeader(valueCount, this.getEncoding(valuesEncoding)));
        Util.writePageHeader(pageHeader, to, blockEncryptor, AAD);
    }

    private static BoundaryOrder toParquetBoundaryOrder(org.apache.flink.table.store.shaded.org.apache.parquet.internal.column.columnindex.BoundaryOrder boundaryOrder) {
        switch (boundaryOrder) {
            case ASCENDING: {
                return BoundaryOrder.ASCENDING;
            }
            case DESCENDING: {
                return BoundaryOrder.DESCENDING;
            }
            case UNORDERED: {
                return BoundaryOrder.UNORDERED;
            }
        }
        throw new IllegalArgumentException("Unsupported boundary order: " + (Object)((Object)boundaryOrder));
    }

    private static org.apache.flink.table.store.shaded.org.apache.parquet.internal.column.columnindex.BoundaryOrder fromParquetBoundaryOrder(BoundaryOrder boundaryOrder) {
        switch (boundaryOrder) {
            case ASCENDING: {
                return org.apache.flink.table.store.shaded.org.apache.parquet.internal.column.columnindex.BoundaryOrder.ASCENDING;
            }
            case DESCENDING: {
                return org.apache.flink.table.store.shaded.org.apache.parquet.internal.column.columnindex.BoundaryOrder.DESCENDING;
            }
            case UNORDERED: {
                return org.apache.flink.table.store.shaded.org.apache.parquet.internal.column.columnindex.BoundaryOrder.UNORDERED;
            }
        }
        throw new IllegalArgumentException("Unsupported boundary order: " + boundaryOrder);
    }

    public static ColumnIndex toParquetColumnIndex(PrimitiveType type, org.apache.flink.table.store.shaded.org.apache.parquet.internal.column.columnindex.ColumnIndex columnIndex) {
        if (!ParquetMetadataConverter.isMinMaxStatsSupported(type) || columnIndex == null) {
            return null;
        }
        ColumnIndex parquetColumnIndex = new ColumnIndex(columnIndex.getNullPages(), columnIndex.getMinValues(), columnIndex.getMaxValues(), ParquetMetadataConverter.toParquetBoundaryOrder(columnIndex.getBoundaryOrder()));
        parquetColumnIndex.setNull_counts(columnIndex.getNullCounts());
        return parquetColumnIndex;
    }

    public static org.apache.flink.table.store.shaded.org.apache.parquet.internal.column.columnindex.ColumnIndex fromParquetColumnIndex(PrimitiveType type, ColumnIndex parquetColumnIndex) {
        if (!ParquetMetadataConverter.isMinMaxStatsSupported(type)) {
            return null;
        }
        return ColumnIndexBuilder.build(type, ParquetMetadataConverter.fromParquetBoundaryOrder(parquetColumnIndex.getBoundary_order()), parquetColumnIndex.getNull_pages(), parquetColumnIndex.getNull_counts(), parquetColumnIndex.getMin_values(), parquetColumnIndex.getMax_values());
    }

    public static OffsetIndex toParquetOffsetIndex(org.apache.flink.table.store.shaded.org.apache.parquet.internal.column.columnindex.OffsetIndex offsetIndex) {
        ArrayList<PageLocation> pageLocations = new ArrayList<PageLocation>(offsetIndex.getPageCount());
        int n = offsetIndex.getPageCount();
        for (int i = 0; i < n; ++i) {
            pageLocations.add(new PageLocation(offsetIndex.getOffset(i), offsetIndex.getCompressedPageSize(i), offsetIndex.getFirstRowIndex(i)));
        }
        return new OffsetIndex(pageLocations);
    }

    public static org.apache.flink.table.store.shaded.org.apache.parquet.internal.column.columnindex.OffsetIndex fromParquetOffsetIndex(OffsetIndex parquetOffsetIndex) {
        OffsetIndexBuilder builder = OffsetIndexBuilder.getBuilder();
        for (PageLocation pageLocation : parquetOffsetIndex.getPage_locations()) {
            builder.add(pageLocation.getOffset(), pageLocation.getCompressed_page_size(), pageLocation.getFirst_row_index());
        }
        return builder.build();
    }

    public static BloomFilterHeader toBloomFilterHeader(BloomFilter bloomFilter) {
        BloomFilterAlgorithm algorithm = null;
        BloomFilterHash hashStrategy = null;
        BloomFilterCompression compression = null;
        if (bloomFilter.getAlgorithm() == BloomFilter.Algorithm.BLOCK) {
            algorithm = BloomFilterAlgorithm.BLOCK(new SplitBlockAlgorithm());
        }
        if (bloomFilter.getHashStrategy() == BloomFilter.HashStrategy.XXH64) {
            hashStrategy = BloomFilterHash.XXHASH(new XxHash());
        }
        if (bloomFilter.getCompression() == BloomFilter.Compression.UNCOMPRESSED) {
            compression = BloomFilterCompression.UNCOMPRESSED(new Uncompressed());
        }
        if (algorithm != null && hashStrategy != null && compression != null) {
            return new BloomFilterHeader(bloomFilter.getBitsetSize(), algorithm, hashStrategy, compression);
        }
        throw new IllegalArgumentException(String.format("Failed to build thrift structure for BloomFilterHeader,algorithm=%s, hash=%s, compression=%s", new Object[]{bloomFilter.getAlgorithm(), bloomFilter.getHashStrategy(), bloomFilter.getCompression()}));
    }

    static final class OffsetMetadataFilter
    extends MetadataFilter {
        private final Set<Long> offsets;

        public OffsetMetadataFilter(Set<Long> offsets) {
            this.offsets = offsets;
        }

        public boolean contains(long offset) {
            return this.offsets.contains(offset);
        }

        @Override
        <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> visitor) throws E {
            return visitor.visit(this);
        }
    }

    static final class RangeMetadataFilter
    extends MetadataFilter {
        final long startOffset;
        final long endOffset;

        RangeMetadataFilter(long startOffset, long endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        @Override
        <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> visitor) throws E {
            return visitor.visit(this);
        }

        public boolean contains(long offset) {
            return offset >= this.startOffset && offset < this.endOffset;
        }

        public String toString() {
            return "range(s:" + this.startOffset + ", e:" + this.endOffset + ")";
        }
    }

    private static final class SkipMetadataFilter
    extends MetadataFilter {
        private SkipMetadataFilter() {
        }

        @Override
        <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> visitor) throws E {
            return visitor.visit(this);
        }

        public String toString() {
            return "SKIP_ROW_GROUPS";
        }
    }

    private static final class NoFilter
    extends MetadataFilter {
        private NoFilter() {
        }

        @Override
        <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> visitor) throws E {
            return visitor.visit(this);
        }

        public String toString() {
            return "NO_FILTER";
        }
    }

    public static abstract class MetadataFilter {
        private MetadataFilter() {
        }

        abstract <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> var1) throws E;
    }

    private static interface MetadataFilterVisitor<T, E extends Throwable> {
        public T visit(NoFilter var1) throws E;

        public T visit(SkipMetadataFilter var1) throws E;

        public T visit(RangeMetadataFilter var1) throws E;

        public T visit(OffsetMetadataFilter var1) throws E;
    }

    static enum SortOrder {
        SIGNED,
        UNSIGNED,
        UNKNOWN;

    }

    private static class LogicalTypeConverterVisitor
    implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<LogicalType> {
        private LogicalTypeConverterVisitor() {
        }

        @Override
        public Optional<LogicalType> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
            return Optional.of(LogicalType.STRING(new StringType()));
        }

        @Override
        public Optional<LogicalType> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation mapLogicalType) {
            return Optional.of(LogicalType.MAP(new MapType()));
        }

        @Override
        public Optional<LogicalType> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation listLogicalType) {
            return Optional.of(LogicalType.LIST(new ListType()));
        }

        @Override
        public Optional<LogicalType> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
            return Optional.of(LogicalType.ENUM(new EnumType()));
        }

        @Override
        public Optional<LogicalType> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
            return Optional.of(LogicalType.DECIMAL(new DecimalType(decimalLogicalType.getScale(), decimalLogicalType.getPrecision())));
        }

        @Override
        public Optional<LogicalType> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
            return Optional.of(LogicalType.DATE(new DateType()));
        }

        @Override
        public Optional<LogicalType> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
            return Optional.of(LogicalType.TIME(new TimeType(timeLogicalType.isAdjustedToUTC(), ParquetMetadataConverter.convertUnit(timeLogicalType.getUnit()))));
        }

        @Override
        public Optional<LogicalType> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
            return Optional.of(LogicalType.TIMESTAMP(new TimestampType(timestampLogicalType.isAdjustedToUTC(), ParquetMetadataConverter.convertUnit(timestampLogicalType.getUnit()))));
        }

        @Override
        public Optional<LogicalType> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
            return Optional.of(LogicalType.INTEGER(new IntType((byte)intLogicalType.getBitWidth(), intLogicalType.isSigned())));
        }

        @Override
        public Optional<LogicalType> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
            return Optional.of(LogicalType.JSON(new JsonType()));
        }

        @Override
        public Optional<LogicalType> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonLogicalType) {
            return Optional.of(LogicalType.BSON(new BsonType()));
        }

        @Override
        public Optional<LogicalType> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidLogicalType) {
            return Optional.of(LogicalType.UUID(new UUIDType()));
        }

        @Override
        public Optional<LogicalType> visit(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation intervalLogicalType) {
            return Optional.of(LogicalType.UNKNOWN(new NullType()));
        }
    }

    private static class ConvertedTypeConverterVisitor
    implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<ConvertedType> {
        private ConvertedTypeConverterVisitor() {
        }

        @Override
        public Optional<ConvertedType> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
            return Optional.of(ConvertedType.UTF8);
        }

        @Override
        public Optional<ConvertedType> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation mapLogicalType) {
            return Optional.of(ConvertedType.MAP);
        }

        @Override
        public Optional<ConvertedType> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation listLogicalType) {
            return Optional.of(ConvertedType.LIST);
        }

        @Override
        public Optional<ConvertedType> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
            return Optional.of(ConvertedType.ENUM);
        }

        @Override
        public Optional<ConvertedType> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
            return Optional.of(ConvertedType.DECIMAL);
        }

        @Override
        public Optional<ConvertedType> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
            return Optional.of(ConvertedType.DATE);
        }

        @Override
        public Optional<ConvertedType> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
            switch (timeLogicalType.getUnit()) {
                case MILLIS: {
                    return Optional.of(ConvertedType.TIME_MILLIS);
                }
                case MICROS: {
                    return Optional.of(ConvertedType.TIME_MICROS);
                }
                case NANOS: {
                    return Optional.empty();
                }
            }
            throw new RuntimeException("Unknown converted type for " + (Object)((Object)timeLogicalType.toOriginalType()));
        }

        @Override
        public Optional<ConvertedType> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
            switch (timestampLogicalType.getUnit()) {
                case MICROS: {
                    return Optional.of(ConvertedType.TIMESTAMP_MICROS);
                }
                case MILLIS: {
                    return Optional.of(ConvertedType.TIMESTAMP_MILLIS);
                }
                case NANOS: {
                    return Optional.empty();
                }
            }
            throw new RuntimeException("Unknown converted type for " + (Object)((Object)timestampLogicalType.toOriginalType()));
        }

        @Override
        public Optional<ConvertedType> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
            boolean signed = intLogicalType.isSigned();
            switch (intLogicalType.getBitWidth()) {
                case 8: {
                    return Optional.of(signed ? ConvertedType.INT_8 : ConvertedType.UINT_8);
                }
                case 16: {
                    return Optional.of(signed ? ConvertedType.INT_16 : ConvertedType.UINT_16);
                }
                case 32: {
                    return Optional.of(signed ? ConvertedType.INT_32 : ConvertedType.UINT_32);
                }
                case 64: {
                    return Optional.of(signed ? ConvertedType.INT_64 : ConvertedType.UINT_64);
                }
            }
            throw new RuntimeException("Unknown original type " + (Object)((Object)intLogicalType.toOriginalType()));
        }

        @Override
        public Optional<ConvertedType> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
            return Optional.of(ConvertedType.JSON);
        }

        @Override
        public Optional<ConvertedType> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonLogicalType) {
            return Optional.of(ConvertedType.BSON);
        }

        @Override
        public Optional<ConvertedType> visit(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation intervalLogicalType) {
            return Optional.of(ConvertedType.INTERVAL);
        }

        @Override
        public Optional<ConvertedType> visit(LogicalTypeAnnotation.MapKeyValueTypeAnnotation mapKeyValueLogicalType) {
            return Optional.of(ConvertedType.MAP_KEY_VALUE);
        }
    }
}

