/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.typeutils;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericData;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericRecord;
import org.apache.flink.avro.shaded.org.apache.avro.io.DatumReader;
import org.apache.flink.avro.shaded.org.apache.avro.io.DatumWriter;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.typeutils.AvroFactory;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.typeutils.AvroSerializerDebugInitHelper;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.typeutils.AvroSerializerSnapshot;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.typeutils.SerializableAvroSchema;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.utils.DataInputDecoder;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.utils.DataOutputEncoder;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(AvroSerializer.class);
    private static final boolean CONCURRENT_ACCESS_CHECK = LOG.isDebugEnabled() || AvroSerializerDebugInitHelper.setToDebug;
    @Nonnull
    private Class<T> type;
    @Nonnull
    private SerializableAvroSchema schema;
    @Nonnull
    private SerializableAvroSchema previousSchema;
    private transient GenericData avroData;
    private transient DatumWriter<T> writer;
    private transient DataOutputEncoder encoder;
    private transient DataInputDecoder decoder;
    private transient DatumReader<T> reader;
    private transient Schema runtimeSchema;
    private transient TypeSerializerSnapshot<T> configSnapshot;
    private volatile transient Thread currentThread;

    public AvroSerializer(Class<T> type) {
        this(Preconditions.checkNotNull(type), new SerializableAvroSchema(), new SerializableAvroSchema());
        Preconditions.checkArgument(!AvroSerializer.isGenericRecord(type), "For GenericData.Record use constructor with explicit schema.");
    }

    public AvroSerializer(Class<T> type, Schema schema) {
        this(Preconditions.checkNotNull(type), new SerializableAvroSchema(Preconditions.checkNotNull(schema)), new SerializableAvroSchema());
        Preconditions.checkArgument(AvroSerializer.isGenericRecord(type), "For classes other than GenericData.Record use constructor without explicit schema.");
    }

    @Internal
    AvroSerializer(Class<T> type, SerializableAvroSchema newSchema, SerializableAvroSchema previousSchema) {
        this.type = Preconditions.checkNotNull(type);
        this.schema = Preconditions.checkNotNull(newSchema);
        this.previousSchema = Preconditions.checkNotNull(previousSchema);
    }

    @Deprecated
    public AvroSerializer(Class<T> type, Class<? extends T> typeToInstantiate) {
        this(type);
    }

    @Nonnull
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public T createInstance() {
        this.checkAvroInitialized();
        return (T)this.avroData.newRecord(null, this.runtimeSchema);
    }

    @Override
    public void serialize(T value, DataOutputView target) throws IOException {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkAvroInitialized();
            this.encoder.setOut(target);
            this.writer.write(value, this.encoder);
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkAvroInitialized();
            this.decoder.setIn(source);
            T t = this.reader.read(null, this.decoder);
            return t;
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkAvroInitialized();
            this.decoder.setIn(source);
            T t = this.reader.read(reuse, this.decoder);
            return t;
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    @Override
    public T copy(T from) {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkAvroInitialized();
            T t = this.avroData.deepCopy(this.runtimeSchema, from);
            return t;
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    @Override
    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    @Override
    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        if (this.configSnapshot == null) {
            this.checkAvroInitialized();
            this.configSnapshot = new AvroSerializerSnapshot<T>(this.runtimeSchema, this.type);
        }
        return this.configSnapshot;
    }

    static boolean isGenericRecord(Class<?> type) {
        return !SpecificRecord.class.isAssignableFrom(type) && GenericRecord.class.isAssignableFrom(type);
    }

    @Override
    public TypeSerializer<T> duplicate() {
        this.checkAvroInitialized();
        return new AvroSerializer<T>(this.type, new SerializableAvroSchema(this.runtimeSchema), this.previousSchema);
    }

    @Override
    public int hashCode() {
        return 42 + this.type.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == AvroSerializer.class) {
            AvroSerializer that = (AvroSerializer)obj;
            return this.type == that.type;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + " (" + this.getType().getName() + ')';
    }

    private void checkAvroInitialized() {
        if (this.writer == null) {
            this.initializeAvro();
        }
    }

    private void initializeAvro() {
        AvroFactory<T> factory = AvroFactory.create(this.type, this.schema.getAvroSchema(), this.previousSchema.getAvroSchema());
        this.runtimeSchema = factory.getSchema();
        this.writer = factory.getWriter();
        this.reader = factory.getReader();
        this.encoder = factory.getEncoder();
        this.decoder = factory.getDecoder();
        this.avroData = factory.getAvroData();
    }

    private void enterExclusiveThread() {
        Thread previous = this.currentThread;
        Thread thisThread = Thread.currentThread();
        if (previous == null) {
            this.currentThread = thisThread;
        } else if (previous != thisThread) {
            throw new IllegalStateException("Concurrent access to KryoSerializer. Thread 1: " + thisThread.getName() + " , Thread 2: " + previous.getName());
        }
    }

    private void exitExclusiveThread() {
        this.currentThread = null;
    }

    Schema getAvroSchema() {
        this.checkAvroInitialized();
        return this.runtimeSchema;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object firstField = in.readObject();
        if (firstField == null) {
            this.read16Layout(null, in);
        } else if (firstField instanceof String) {
            this.read16Layout((String)firstField, in);
        } else if (firstField instanceof Class) {
            Class type = (Class)firstField;
            this.read15Layout(type);
        } else if (firstField instanceof SerializableAvroSchema) {
            this.readCurrentLayout((SerializableAvroSchema)firstField, in);
        } else {
            throw new IllegalStateException("Failed to Java-Deserialize an AvroSerializer instance. Was expecting a first field to be either a String or SerializableAvroSchema, but got: " + firstField.getClass());
        }
    }

    private void read15Layout(Class<T> type) {
        this.previousSchema = new SerializableAvroSchema();
        this.schema = new SerializableAvroSchema();
        this.type = type;
    }

    private void read16Layout(@Nullable String schemaString, ObjectInputStream in) throws IOException, ClassNotFoundException {
        Schema schema = AvroFactory.parseSchemaString(schemaString);
        Class type = (Class)in.readObject();
        this.previousSchema = new SerializableAvroSchema();
        this.schema = new SerializableAvroSchema(schema);
        this.type = type;
    }

    private void readCurrentLayout(SerializableAvroSchema previousSchema, ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.previousSchema = previousSchema;
        this.schema = (SerializableAvroSchema)in.readObject();
        this.type = (Class)in.readObject();
    }

    @Deprecated
    public static final class AvroSchemaSerializerConfigSnapshot<T>
    extends AvroSerializerSnapshot<T> {
    }
}

