/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.types.RowKind;

public class DropDeleteReader
implements RecordReader<KeyValue> {
    private final RecordReader<KeyValue> reader;

    public DropDeleteReader(RecordReader<KeyValue> reader) {
        this.reader = reader;
    }

    @Override
    @Nullable
    public RecordReader.RecordIterator<KeyValue> readBatch() throws IOException {
        final RecordReader.RecordIterator<KeyValue> batch = this.reader.readBatch();
        if (batch == null) {
            return null;
        }
        return new RecordReader.RecordIterator<KeyValue>(){

            @Override
            public KeyValue next() throws IOException {
                KeyValue kv;
                do {
                    if ((kv = (KeyValue)batch.next()) != null) continue;
                    return null;
                } while (kv.valueKind() != RowKind.INSERT && kv.valueKind() != RowKind.UPDATE_AFTER);
                return kv;
            }

            @Override
            public void releaseBatch() {
                batch.releaseBatch();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

