/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.catalog;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.CatalogOptions;
import org.apache.flink.table.store.file.catalog.Catalog;
import org.apache.flink.table.store.file.catalog.CatalogFactory;
import org.apache.flink.table.store.file.catalog.FileSystemCatalog;
import org.apache.flink.table.store.table.TableType;

public class FileSystemCatalogFactory
implements CatalogFactory {
    public static final String IDENTIFIER = "filesystem";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Catalog create(String warehouse, Configuration options) {
        if (!TableType.MANAGED.equals(options.get(CatalogOptions.TABLE_TYPE))) {
            throw new IllegalArgumentException("Only managed table is supported in File system catalog.");
        }
        return new FileSystemCatalog(new Path(warehouse));
    }
}

