/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.store.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.IMetaStoreSchemaInfo;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.tools.HiveSchemaHelper;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.utils.MetastoreVersionInfo;

public class MetaStoreSchemaInfo
implements IMetaStoreSchemaInfo {
    protected static final String UPGRADE_FILE_PREFIX = "upgrade-";
    protected static final String INIT_FILE_PREFIX = "hive-schema-";
    protected static final String VERSION_UPGRADE_LIST = "upgrade.order";
    protected static final String PRE_UPGRADE_PREFIX = "pre-";
    protected static final String CREATE_USER_PREFIX = "create-user";
    private String[] hiveSchemaVersions;
    private final String metastoreHome;
    protected final String dbType;
    private static final Map<String, String> EQUIVALENT_VERSIONS = ImmutableMap.of("0.13.1", "0.13.0", "1.0.0", "0.14.0", "1.0.1", "1.0.0", "1.1.1", "1.1.0", "1.2.1", "1.2.0");

    public MetaStoreSchemaInfo(String metastoreHome, String dbType) throws HiveMetaException {
        this.metastoreHome = metastoreHome;
        this.dbType = dbType;
    }

    private void loadAllUpgradeScripts(String dbType) throws HiveMetaException {
        ArrayList<String> upgradeOrderList = new ArrayList<String>();
        String upgradeListFile = this.getMetaStoreScriptDir() + File.separator + VERSION_UPGRADE_LIST + "." + dbType;
        try (FileReader fr = new FileReader(upgradeListFile);
             BufferedReader bfReader = new BufferedReader(fr);){
            String currSchemaVersion;
            while ((currSchemaVersion = bfReader.readLine()) != null) {
                upgradeOrderList.add(currSchemaVersion.trim());
            }
        }
        catch (FileNotFoundException e) {
            throw new HiveMetaException("File " + upgradeListFile + "not found ", e);
        }
        catch (IOException e) {
            throw new HiveMetaException("Error reading " + upgradeListFile, e);
        }
        this.hiveSchemaVersions = upgradeOrderList.toArray(new String[0]);
    }

    @Override
    public List<String> getUpgradeScripts(String fromVersion) throws HiveMetaException {
        int i;
        ArrayList<String> upgradeScriptList = new ArrayList<String>();
        if (this.getHiveSchemaVersion().equals(fromVersion)) {
            return upgradeScriptList;
        }
        this.loadAllUpgradeScripts(this.dbType);
        int firstScript = this.hiveSchemaVersions.length;
        for (i = 0; i < this.hiveSchemaVersions.length; ++i) {
            if (!this.hiveSchemaVersions[i].startsWith(fromVersion)) continue;
            firstScript = i;
        }
        if (firstScript == this.hiveSchemaVersions.length) {
            throw new HiveMetaException("Unknown version specified for upgrade " + fromVersion + " Metastore schema may be too old or newer");
        }
        for (i = firstScript; i < this.hiveSchemaVersions.length; ++i) {
            String scriptFile = this.generateUpgradeFileName(this.hiveSchemaVersions[i]);
            upgradeScriptList.add(scriptFile);
        }
        return upgradeScriptList;
    }

    @Override
    public String generateInitFileName(String toVersion) throws HiveMetaException {
        if (toVersion == null) {
            toVersion = this.getHiveSchemaVersion();
        }
        String initScriptName = INIT_FILE_PREFIX + toVersion + "." + this.dbType + ".sql";
        if (!new File(this.getMetaStoreScriptDir() + File.separatorChar + initScriptName).exists()) {
            throw new HiveMetaException("Unknown version specified for initialization: " + toVersion);
        }
        return initScriptName;
    }

    @Override
    public String getCreateUserScript() throws HiveMetaException {
        String createScript = "create-user." + this.dbType + ".sql";
        if (!new File(this.getMetaStoreScriptDir() + File.separatorChar + createScript).exists()) {
            throw new HiveMetaException("Unable to find create user file, expected: " + createScript);
        }
        return createScript;
    }

    @Override
    public String getMetaStoreScriptDir() {
        return this.metastoreHome + File.separatorChar + "scripts" + File.separatorChar + "metastore" + File.separatorChar + "upgrade" + File.separatorChar + this.dbType;
    }

    private String generateUpgradeFileName(String fileVersion) {
        return UPGRADE_FILE_PREFIX + fileVersion + "." + this.dbType + ".sql";
    }

    @Override
    public String getPreUpgradeScriptName(int index, String upgradeScriptName) {
        return PRE_UPGRADE_PREFIX + index + "-" + upgradeScriptName;
    }

    @Override
    public String getHiveSchemaVersion() {
        String hiveVersion = MetastoreVersionInfo.getShortVersion();
        return MetaStoreSchemaInfo.getEquivalentVersion(hiveVersion);
    }

    private static String getEquivalentVersion(String hiveVersion) {
        String equivalentVersion = EQUIVALENT_VERSIONS.get(hiveVersion);
        if (equivalentVersion != null) {
            return equivalentVersion;
        }
        return hiveVersion;
    }

    @Override
    public boolean isVersionCompatible(String hiveVersion, String dbVersion) {
        if ((hiveVersion = MetaStoreSchemaInfo.getEquivalentVersion(hiveVersion)).equals(dbVersion = MetaStoreSchemaInfo.getEquivalentVersion(dbVersion))) {
            return true;
        }
        String[] hiveVerParts = hiveVersion.split("\\.");
        String[] dbVerParts = dbVersion.split("\\.");
        if (hiveVerParts.length != 3 || dbVerParts.length != 3) {
            return false;
        }
        for (int i = 0; i < dbVerParts.length; ++i) {
            int hiveVerPart;
            int dbVerPart = Integer.parseInt(dbVerParts[i]);
            if (dbVerPart > (hiveVerPart = Integer.parseInt(hiveVerParts[i]))) {
                return true;
            }
            if (dbVerPart >= hiveVerPart) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getMetaStoreSchemaVersion(HiveSchemaHelper.MetaStoreConnectionInfo connectionInfo) throws HiveMetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

