/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.hll;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;

public class HyperLogLogUtils {
    public static final byte[] MAGIC = new byte[]{72, 76, 76};

    public static void serializeHLL(OutputStream out, HyperLogLog hll) throws IOException {
        out.write(MAGIC);
        int fourthByte = 0;
        int p = hll.getNumRegisterIndexBits();
        fourthByte = (p & 0xFF) << 4;
        int bitWidth = 0;
        HyperLogLog.EncodingType enc = hll.getEncoding();
        if (enc.equals((Object)HyperLogLog.EncodingType.DENSE)) {
            int lzr = hll.getHLLDenseRegister().getMaxRegisterValue();
            bitWidth = HyperLogLogUtils.getBitWidth(lzr);
            if (bitWidth > 6) {
                fourthByte |= 7;
                bitWidth = 8;
            } else {
                fourthByte |= bitWidth & 7;
            }
        }
        out.write(fourthByte);
        long estCount = hll.estimateNumDistinctValues();
        HyperLogLogUtils.writeVulong(out, estCount);
        if (enc.equals((Object)HyperLogLog.EncodingType.DENSE)) {
            byte[] register = hll.getHLLDenseRegister().getRegister();
            HyperLogLogUtils.bitpackHLLRegister(out, register, bitWidth);
        } else if (enc.equals((Object)HyperLogLog.EncodingType.SPARSE)) {
            TreeMap<Integer, Byte> sparseMap = hll.getHLLSparseRegister().getSparseMap();
            HyperLogLogUtils.writeVulong(out, sparseMap.size());
            int prev = 0;
            for (Map.Entry<Integer, Byte> entry : sparseMap.entrySet()) {
                if (prev == 0) {
                    prev = entry.getKey() << 6 | entry.getValue();
                    HyperLogLogUtils.writeVulong(out, prev);
                    continue;
                }
                int curr = entry.getKey() << 6 | entry.getValue();
                int delta = curr - prev;
                HyperLogLogUtils.writeVulong(out, delta);
                prev = curr;
            }
        }
    }

    public static HyperLogLog deserializeHLL(InputStream in) throws IOException {
        HyperLogLogUtils.checkMagicString(in);
        int fourthByte = in.read() & 0xFF;
        int p = fourthByte >>> 4;
        int enc = fourthByte & 7;
        HyperLogLog.EncodingType encoding = null;
        int bitSize = 0;
        if (enc == 0) {
            encoding = HyperLogLog.EncodingType.SPARSE;
        } else if (enc > 0 && enc < 7) {
            bitSize = enc;
            encoding = HyperLogLog.EncodingType.DENSE;
        } else {
            bitSize = 8;
            encoding = HyperLogLog.EncodingType.DENSE;
        }
        long estCount = HyperLogLogUtils.readVulong(in);
        HyperLogLog result = null;
        if (encoding.equals((Object)HyperLogLog.EncodingType.SPARSE)) {
            result = HyperLogLog.builder().setNumRegisterIndexBits(p).setEncoding(HyperLogLog.EncodingType.SPARSE).build();
            int numRegisterEntries = (int)HyperLogLogUtils.readVulong(in);
            int[] reg = new int[numRegisterEntries];
            int prev = 0;
            if (numRegisterEntries > 0) {
                reg[0] = prev = (int)HyperLogLogUtils.readVulong(in);
            }
            int delta = 0;
            int curr = 0;
            for (int i = 1; i < numRegisterEntries; ++i) {
                delta = (int)HyperLogLogUtils.readVulong(in);
                reg[i] = curr = prev + delta;
                prev = curr;
            }
            result.setHLLSparseRegister(reg);
        } else {
            result = bitSize == 8 ? HyperLogLog.builder().setNumRegisterIndexBits(p).setEncoding(HyperLogLog.EncodingType.DENSE).enableBitPacking(false).build() : HyperLogLog.builder().setNumRegisterIndexBits(p).setEncoding(HyperLogLog.EncodingType.DENSE).enableBitPacking(true).build();
            int m = 1 << p;
            byte[] register = HyperLogLogUtils.unpackHLLRegister(in, m, bitSize);
            result.setHLLDenseRegister(register);
        }
        result.setCount(estCount);
        return result;
    }

    public static HyperLogLog deserializeHLL(byte[] buf) {
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        try {
            HyperLogLog result = HyperLogLogUtils.deserializeHLL(is);
            ((InputStream)is).close();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void bitpackHLLRegister(OutputStream out, byte[] register, int bitWidth) throws IOException {
        int bitsLeft = 8;
        int current = 0;
        if (bitWidth == 8) {
            HyperLogLogUtils.fastPathWrite(out, register);
            return;
        }
        for (byte value : register) {
            int bitsToWrite = bitWidth;
            while (bitsToWrite > bitsLeft) {
                current = (byte)(current | value >>> bitsToWrite - bitsLeft);
                value = (byte)(value & (1 << (bitsToWrite -= bitsLeft)) - 1);
                out.write(current);
                current = 0;
                bitsLeft = 8;
            }
            current = (byte)(current | value << (bitsLeft -= bitsToWrite));
            if (bitsLeft != 0) continue;
            out.write(current);
            current = 0;
            bitsLeft = 8;
        }
        out.flush();
    }

    private static void fastPathWrite(OutputStream out, byte[] register) throws IOException {
        for (byte b : register) {
            out.write(b);
        }
    }

    private static byte[] unpackHLLRegister(InputStream in, int length, int bitSize) throws IOException {
        int mask = (1 << bitSize) - 1;
        int bitsLeft = 8;
        if (bitSize == 8) {
            return HyperLogLogUtils.fastPathRead(in, length);
        }
        byte current = (byte)(0xFF & in.read());
        byte[] output = new byte[length];
        for (int i = 0; i < output.length; ++i) {
            int bitsLeftToRead;
            int result = 0;
            for (bitsLeftToRead = bitSize; bitsLeftToRead > bitsLeft; bitsLeftToRead -= bitsLeft) {
                result = (byte)(result << bitsLeft);
                result = (byte)(result | current & (1 << bitsLeft) - 1);
                current = (byte)(0xFF & in.read());
                bitsLeft = 8;
            }
            if (bitsLeftToRead > 0) {
                result = (byte)(result << bitsLeftToRead);
                result = (byte)(result | current >>> (bitsLeft -= bitsLeftToRead) & (1 << bitsLeftToRead) - 1);
            }
            output[i] = (byte)(result & mask);
        }
        return output;
    }

    private static byte[] fastPathRead(InputStream in, int length) throws IOException {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)in.read();
        }
        return result;
    }

    public static long getEstimatedCountFromSerializedHLL(InputStream in) throws IOException {
        HyperLogLogUtils.checkMagicString(in);
        in.read();
        return HyperLogLogUtils.readVulong(in);
    }

    private static void checkMagicString(InputStream in) throws IOException {
        byte[] magic = new byte[]{(byte)in.read(), (byte)in.read(), (byte)in.read()};
        if (!Arrays.equals(magic, MAGIC)) {
            throw new IllegalArgumentException("The input stream is not a HyperLogLog stream.");
        }
    }

    private static int getBitWidth(int val) {
        int count = 0;
        while (val != 0) {
            ++count;
            val = (byte)(val >>> 1);
        }
        return count;
    }

    public static float getRelativeError(long actualCount, long estimatedCount) {
        float err = (1.0f - (float)estimatedCount / (float)actualCount) * 100.0f;
        return err;
    }

    private static void writeVulong(OutputStream output, long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                output.write((byte)value);
                return;
            }
            output.write((byte)(0x80L | value & 0x7FL));
            value >>>= 7;
        }
    }

    private static long readVulong(InputStream in) throws IOException {
        long b;
        long result = 0L;
        int offset = 0;
        do {
            if ((b = (long)in.read()) == -1L) {
                throw new EOFException("Reading Vulong past EOF");
            }
            result |= (0x7FL & b) << offset;
            offset += 7;
        } while (b >= 128L);
        return result;
    }
}

