/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.hll;

import java.util.Arrays;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.hll.HLLConstants;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.hll.HLLRegister;

public class HLLDenseRegister
implements HLLRegister {
    private byte[] register;
    private int maxRegisterValue;
    private int p;
    private int m;

    public HLLDenseRegister(int p) {
        this(p, true);
    }

    public HLLDenseRegister(int p, boolean bitPack) {
        this.p = p;
        this.m = 1 << p;
        this.register = new byte[this.m];
        this.maxRegisterValue = 0;
        if (!bitPack) {
            this.maxRegisterValue = 255;
        }
    }

    @Override
    public boolean add(long hashcode) {
        int registerIdx = (int)(hashcode & (long)(this.m - 1));
        long w = hashcode >>> this.p;
        int lr = Long.numberOfTrailingZeros(w) + 1;
        return this.set(registerIdx, (byte)lr);
    }

    public void extractLowBitsTo(HLLRegister dest) {
        for (int idx = 0; idx < this.register.length; ++idx) {
            byte lr = this.register[idx];
            if (lr == 0) continue;
            dest.add(1 << this.p + lr - 1 | idx);
        }
    }

    @Override
    public boolean set(int idx, byte value) {
        boolean updated = false;
        if (idx < this.register.length && value > this.register[idx]) {
            if (value > this.maxRegisterValue) {
                this.maxRegisterValue = value;
            }
            this.register[idx] = value;
            updated = true;
        }
        return updated;
    }

    public int size() {
        return this.register.length;
    }

    public int getNumZeroes() {
        int numZeroes = 0;
        for (byte b : this.register) {
            if (b != 0) continue;
            ++numZeroes;
        }
        return numZeroes;
    }

    @Override
    public void merge(HLLRegister hllRegister) {
        if (hllRegister instanceof HLLDenseRegister) {
            HLLDenseRegister hdr = (HLLDenseRegister)hllRegister;
            byte[] inRegister = hdr.getRegister();
            if (this.register.length != inRegister.length) {
                throw new IllegalArgumentException("The size of register sets of HyperLogLogs to be merged does not match.");
            }
            for (int i = 0; i < inRegister.length; ++i) {
                byte ob = inRegister[i];
                byte cb = this.register[i];
                this.register[i] = ob > cb ? ob : cb;
            }
            if (hdr.getMaxRegisterValue() > this.maxRegisterValue) {
                this.maxRegisterValue = hdr.getMaxRegisterValue();
            }
        } else {
            throw new IllegalArgumentException("Specified register is not instance of HLLDenseRegister");
        }
    }

    public byte[] getRegister() {
        return this.register;
    }

    public void setRegister(byte[] register) {
        this.register = register;
    }

    public int getMaxRegisterValue() {
        return this.maxRegisterValue;
    }

    public double getSumInversePow2() {
        double sum = 0.0;
        for (byte b : this.register) {
            sum += HLLConstants.inversePow2Data[b];
        }
        return sum;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HLLDenseRegister - ");
        sb.append("p: ");
        sb.append(this.p);
        sb.append(" numZeroes: ");
        sb.append(this.getNumZeroes());
        sb.append(" maxRegisterValue: ");
        sb.append(this.maxRegisterValue);
        return sb.toString();
    }

    public String toExtendedString() {
        return this.toString() + " register: " + Arrays.toString(this.register);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HLLDenseRegister)) {
            return false;
        }
        HLLDenseRegister other = (HLLDenseRegister)obj;
        return this.maxRegisterValue == other.maxRegisterValue && Arrays.equals(this.register, other.register);
    }

    public int hashCode() {
        int hashcode = 0;
        hashcode += 31 * this.maxRegisterValue;
        return hashcode += Arrays.hashCode(this.register);
    }
}

