/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.hbase;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.binary.Base64;
import org.apache.flink.table.store.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.hbase.HBaseReadWrite;
import org.apache.hadoop.conf.Configuration;

public class HBaseSchemaTool {
    public static void main(String[] args) {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"You're looking at it");
        options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"install");
        OptionBuilder.withDescription((String)"Install the schema onto an HBase cluster.");
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"key");
        OptionBuilder.withDescription((String)"Key to scan with.  This should be an exact key (not a regular expression");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'k'));
        OptionBuilder.withLongOpt((String)"list-tables");
        OptionBuilder.withDescription((String)"List tables in HBase metastore");
        options.addOption(OptionBuilder.create((char)'l'));
        OptionBuilder.withLongOpt((String)"regex-key");
        OptionBuilder.withDescription((String)"Regular expression to scan keys with.");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withLongOpt((String)"table");
        OptionBuilder.withDescription((String)"HBase metastore table to scan");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'t'));
        CommandLine cli = null;
        try {
            cli = new GnuParser().parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("Parse Exception: " + e.getMessage());
            HBaseSchemaTool.usage(options);
            return;
        }
        if (cli.hasOption('h')) {
            HBaseSchemaTool.usage(options);
            return;
        }
        Configuration conf = new Configuration();
        if (cli.hasOption('i')) {
            new HBaseSchemaTool().install(conf, System.err);
            return;
        }
        String key = null;
        if (cli.hasOption('k')) {
            key = cli.getOptionValue('k');
        }
        String regex = null;
        if (cli.hasOption('r')) {
            regex = cli.getOptionValue('r');
        }
        if (key != null && regex != null) {
            HBaseSchemaTool.usage(options);
            return;
        }
        if (key == null && regex == null) {
            regex = ".*";
        }
        new HBaseSchemaTool().go(cli.hasOption('l'), cli.getOptionValue('t'), key, regex, conf, System.out, System.err);
    }

    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String header = "This tool dumps contents of your hbase metastore.  You need to specify\nthe table to dump.  You can optionally specify a regular expression on the key for\nthe table.  Keep in mind that the key is often a compound.  For partitions regular\nexpressions are not used because non-string values are\nstored in binary.  Instead for partition you can specify as much of the exact prefix as you want.  So you can give dbname.tablename or dbname.tablename.pval1...";
        String footer = "If neither key or regex is provided a regex of .* will be assumed.  You\ncannot set both key and regex.";
        formatter.printHelp("hbaseschematool", header, options, footer);
    }

    @VisibleForTesting
    void go(boolean listTables, String table, String key, String regex, Configuration conf, PrintStream out, PrintStream err) {
        List<Object> lines;
        block30: {
            lines = new ArrayList();
            if (listTables) {
                lines = Arrays.asList(HBaseReadWrite.tableNames);
            } else {
                if (key != null) {
                    key = key.replace('.', '\u0001');
                }
                try {
                    HBaseReadWrite.setConf(conf);
                    HBaseReadWrite hrw = HBaseReadWrite.getInstance();
                    if (table.equalsIgnoreCase("HBMS_DBS")) {
                        if (key != null) {
                            lines.add(hrw.printDatabase(key));
                        } else {
                            lines.addAll(hrw.printDatabases(regex));
                        }
                        break block30;
                    }
                    if (table.equalsIgnoreCase("HBMS_FUNCS")) {
                        if (key != null) {
                            lines.add(hrw.printFunction(key));
                        } else {
                            lines.addAll(hrw.printFunctions(regex));
                        }
                        break block30;
                    }
                    if (table.equalsIgnoreCase("HBMS_GLOBAL_PRIVS")) {
                        lines.add(hrw.printGlobalPrivs());
                        break block30;
                    }
                    if (table.equalsIgnoreCase("HBMS_PARTITIONS")) {
                        if (key != null) {
                            lines.add(hrw.printPartition(key));
                        } else {
                            lines.addAll(hrw.printPartitions(regex));
                        }
                        break block30;
                    }
                    if (table.equalsIgnoreCase("HBMS_USER_TO_ROLE")) {
                        if (key != null) {
                            lines.add(hrw.printRolesForUser(key));
                        } else {
                            lines.addAll(hrw.printRolesForUsers(regex));
                        }
                        break block30;
                    }
                    if (table.equalsIgnoreCase("HBMS_ROLES")) {
                        if (key != null) {
                            lines.add(hrw.printRole(key));
                        } else {
                            lines.addAll(hrw.printRoles(regex));
                        }
                        break block30;
                    }
                    if (table.equalsIgnoreCase("HBMS_TBLS")) {
                        if (key != null) {
                            lines.add(hrw.printTable(key));
                        } else {
                            lines.addAll(hrw.printTables(regex));
                        }
                        break block30;
                    }
                    if (table.equalsIgnoreCase("HBMS_SDS")) {
                        if (key != null) {
                            lines.add(hrw.printStorageDescriptor(Base64.decodeBase64((String)key)));
                        } else {
                            lines.addAll(hrw.printStorageDescriptors());
                        }
                        break block30;
                    }
                    if (table.equalsIgnoreCase("HBMS_SECURITY")) {
                        lines.addAll(hrw.printSecurity());
                        break block30;
                    }
                    if (table.equalsIgnoreCase("HBMS_SEQUENCES")) {
                        lines.addAll(hrw.printSequences());
                        break block30;
                    }
                    err.println("Unknown table: " + table);
                    return;
                }
                catch (Exception e) {
                    err.println("Caught exception " + e.getClass() + " with message: " + e.getMessage());
                    return;
                }
            }
        }
        for (String string : lines) {
            out.println(string);
        }
    }

    @VisibleForTesting
    void install(Configuration conf, PrintStream err) {
        try {
            HBaseReadWrite.setConf(conf);
            HBaseReadWrite.createTablesIfNotExist();
        }
        catch (Exception e) {
            err.println("Caught exception " + e.getClass() + " with message: " + e.getMessage());
            return;
        }
    }
}

