/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table;

import java.io.IOException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.AppendOnlyFileStore;
import org.apache.flink.table.store.file.operation.AppendOnlyFileStoreRead;
import org.apache.flink.table.store.file.operation.AppendOnlyFileStoreScan;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.table.AbstractFileStoreTable;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.sink.SinkRecordConverter;
import org.apache.flink.table.store.table.sink.TableWrite;
import org.apache.flink.table.store.table.sink.TableWriteImpl;
import org.apache.flink.table.store.table.source.AbstractDataTableScan;
import org.apache.flink.table.store.table.source.AppendOnlySplitGenerator;
import org.apache.flink.table.store.table.source.DataSplit;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.store.table.source.SplitGenerator;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class AppendOnlyFileStoreTable
extends AbstractFileStoreTable {
    private static final long serialVersionUID = 1L;
    private transient AppendOnlyFileStore lazyStore;

    AppendOnlyFileStoreTable(Path path, TableSchema tableSchema) {
        super(path, tableSchema);
    }

    @Override
    protected FileStoreTable copy(TableSchema newTableSchema) {
        return new AppendOnlyFileStoreTable(this.path, newTableSchema);
    }

    public AppendOnlyFileStore store() {
        if (this.lazyStore == null) {
            this.lazyStore = new AppendOnlyFileStore(this.schemaManager(), this.tableSchema.id(), new CoreOptions(this.tableSchema.options()), this.tableSchema.logicalPartitionType(), this.tableSchema.logicalBucketKeyType(), this.tableSchema.logicalRowType());
        }
        return this.lazyStore;
    }

    @Override
    public AbstractDataTableScan newScan() {
        final AppendOnlyFileStoreScan scan = this.store().newScan();
        return new AbstractDataTableScan(scan, this.tableSchema, this.store().pathFactory(), this.options()){

            @Override
            protected SplitGenerator splitGenerator(FileStorePathFactory pathFactory) {
                return new AppendOnlySplitGenerator(AppendOnlyFileStoreTable.this.store().options().splitTargetSize(), AppendOnlyFileStoreTable.this.store().options().splitOpenFileCost());
            }

            @Override
            protected void withNonPartitionFilter(Predicate predicate) {
                scan.withFilter(predicate);
            }
        };
    }

    @Override
    public TableRead newRead() {
        final AppendOnlyFileStoreRead read = this.store().newRead();
        return new TableRead(){

            @Override
            public TableRead withFilter(Predicate predicate) {
                read.withFilter(predicate);
                return this;
            }

            @Override
            public TableRead withProjection(int[][] projection) {
                read.withProjection(projection);
                return this;
            }

            @Override
            public RecordReader<RowData> createReader(Split split) throws IOException {
                return read.createReader((DataSplit)split);
            }
        };
    }

    @Override
    public TableWrite newWrite(String commitUser) {
        return new TableWriteImpl<RowData>(this.store().newWrite(commitUser), new SinkRecordConverter(this.tableSchema), record -> {
            Preconditions.checkState((record.row().getRowKind() == RowKind.INSERT ? 1 : 0) != 0, (String)"Append only writer can not accept row with RowKind %s", (Object[])new Object[]{record.row().getRowKind()});
            return record.row();
        });
    }
}

