/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.parquet.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.store.shaded.org.apache.parquet.Preconditions;
import org.apache.flink.table.store.shaded.org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.flink.table.store.shaded.org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.flink.table.store.shaded.org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.ClientSideMetadataSplitStrategy;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.Footer;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.LruCache;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.api.InitContext;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.GlobalMetaData;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.util.ConfigurationUtil;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.util.HiddenFileFilter;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.util.SerializationUtil;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.ParquetDecodingException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetInputFormat<T>
extends FileInputFormat<Void, T> {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetInputFormat.class);
    public static final String READ_SUPPORT_CLASS = "parquet.read.support.class";
    public static final String UNBOUND_RECORD_FILTER = "parquet.read.filter";
    public static final String STRICT_TYPE_CHECKING = "parquet.strict.typing";
    public static final String FILTER_PREDICATE = "parquet.private.read.filter.predicate";
    public static final String RECORD_FILTERING_ENABLED = "parquet.filter.record-level.enabled";
    public static final String STATS_FILTERING_ENABLED = "parquet.filter.stats.enabled";
    public static final String DICTIONARY_FILTERING_ENABLED = "parquet.filter.dictionary.enabled";
    public static final String COLUMN_INDEX_FILTERING_ENABLED = "parquet.filter.columnindex.enabled";
    public static final String PAGE_VERIFY_CHECKSUM_ENABLED = "parquet.page.verify-checksum.enabled";
    public static final String TASK_SIDE_METADATA = "parquet.task.side.metadata";
    public static final String SPLIT_FILES = "parquet.split.files";
    private static final int MIN_FOOTER_CACHE_SIZE = 100;
    private LruCache<FileStatusWrapper, FootersCacheValue> footersCache;
    private final Class<? extends ReadSupport<T>> readSupportClass;

    public static void setTaskSideMetaData(Job job, boolean taskSideMetadata) {
        ContextUtil.getConfiguration((JobContext)job).setBoolean(TASK_SIDE_METADATA, taskSideMetadata);
    }

    public static boolean isTaskSideMetaData(Configuration configuration) {
        return configuration.getBoolean(TASK_SIDE_METADATA, Boolean.TRUE.booleanValue());
    }

    public static void setReadSupportClass(Job job, Class<?> readSupportClass) {
        ContextUtil.getConfiguration((JobContext)job).set(READ_SUPPORT_CLASS, readSupportClass.getName());
    }

    public static void setUnboundRecordFilter(Job job, Class<? extends UnboundRecordFilter> filterClass) {
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Preconditions.checkArgument(ParquetInputFormat.getFilterPredicate(conf) == null, "You cannot provide an UnboundRecordFilter after providing a FilterPredicate");
        conf.set(UNBOUND_RECORD_FILTER, filterClass.getName());
    }

    @Deprecated
    public static Class<?> getUnboundRecordFilter(Configuration configuration) {
        return ConfigurationUtil.getClassFromConfig(configuration, UNBOUND_RECORD_FILTER, UnboundRecordFilter.class);
    }

    private static UnboundRecordFilter getUnboundRecordFilterInstance(Configuration configuration) {
        Class<?> clazz = ConfigurationUtil.getClassFromConfig(configuration, UNBOUND_RECORD_FILTER, UnboundRecordFilter.class);
        if (clazz == null) {
            return null;
        }
        try {
            UnboundRecordFilter unboundRecordFilter = (UnboundRecordFilter)clazz.newInstance();
            if (unboundRecordFilter instanceof Configurable) {
                ((Configurable)unboundRecordFilter).setConf(configuration);
            }
            return unboundRecordFilter;
        }
        catch (InstantiationException e) {
            throw new BadConfigurationException("could not instantiate unbound record filter class", e);
        }
        catch (IllegalAccessException e) {
            throw new BadConfigurationException("could not instantiate unbound record filter class", e);
        }
    }

    public static void setReadSupportClass(JobConf conf, Class<?> readSupportClass) {
        conf.set(READ_SUPPORT_CLASS, readSupportClass.getName());
    }

    public static Class<?> getReadSupportClass(Configuration configuration) {
        return ConfigurationUtil.getClassFromConfig(configuration, READ_SUPPORT_CLASS, ReadSupport.class);
    }

    public static void setFilterPredicate(Configuration configuration, FilterPredicate filterPredicate) {
        Preconditions.checkArgument(ParquetInputFormat.getUnboundRecordFilter(configuration) == null, "You cannot provide a FilterPredicate after providing an UnboundRecordFilter");
        configuration.set("parquet.private.read.filter.predicate.human.readable", filterPredicate.toString());
        try {
            SerializationUtil.writeObjectToConfAsBase64(FILTER_PREDICATE, filterPredicate, configuration);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static FilterPredicate getFilterPredicate(Configuration configuration) {
        try {
            return (FilterPredicate)SerializationUtil.readObjectFromConfAsBase64(FILTER_PREDICATE, configuration);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FilterCompat.Filter getFilter(Configuration conf) {
        return FilterCompat.get(ParquetInputFormat.getFilterPredicate(conf), ParquetInputFormat.getUnboundRecordFilterInstance(conf));
    }

    public ParquetInputFormat() {
        this.readSupportClass = null;
    }

    public <S extends ReadSupport<T>> ParquetInputFormat(Class<S> readSupportClass) {
        this.readSupportClass = readSupportClass;
    }

    public RecordReader<Void, T> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration conf = ContextUtil.getConfiguration((JobContext)taskAttemptContext);
        ReadSupport<T> readSupport = this.getReadSupport(conf);
        return new ParquetRecordReader<T>(readSupport, ParquetInputFormat.getFilter(conf));
    }

    @Deprecated
    ReadSupport<T> getReadSupport(Configuration configuration) {
        return ParquetInputFormat.getReadSupportInstance(this.readSupportClass == null ? ParquetInputFormat.getReadSupportClass(configuration) : this.readSupportClass);
    }

    public static <T> ReadSupport<T> getReadSupportInstance(Configuration configuration) {
        return ParquetInputFormat.getReadSupportInstance(ParquetInputFormat.getReadSupportClass(configuration));
    }

    static <T> ReadSupport<T> getReadSupportInstance(Class<? extends ReadSupport<T>> readSupportClass) {
        try {
            return readSupportClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new BadConfigurationException("could not instantiate read support class", e);
        }
        catch (IllegalAccessException e) {
            throw new BadConfigurationException("could not instantiate read support class", e);
        }
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        return ContextUtil.getConfiguration(context).getBoolean(SPLIT_FILES, true);
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException {
        Configuration configuration = ContextUtil.getConfiguration(jobContext);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        if (ParquetInputFormat.isTaskSideMetaData(configuration)) {
            for (InputSplit split : super.getSplits(jobContext)) {
                Preconditions.checkArgument(split instanceof FileSplit, "Cannot wrap non-FileSplit: " + split);
                splits.add((InputSplit)ParquetInputSplit.from((FileSplit)split));
            }
            return splits;
        }
        splits.addAll(this.getSplits(configuration, this.getFooters(jobContext)));
        return splits;
    }

    @Deprecated
    public List<ParquetInputSplit> getSplits(Configuration configuration, List<Footer> footers) throws IOException {
        boolean strictTypeChecking = configuration.getBoolean(STRICT_TYPE_CHECKING, true);
        long maxSplitSize = configuration.getLong("mapred.max.split.size", Long.MAX_VALUE);
        long minSplitSize = Math.max(this.getFormatMinSplitSize(), configuration.getLong("mapred.min.split.size", 0L));
        if (maxSplitSize < 0L || minSplitSize < 0L) {
            throw new ParquetDecodingException("maxSplitSize or minSplitSize should not be negative: maxSplitSize = " + maxSplitSize + "; minSplitSize = " + minSplitSize);
        }
        GlobalMetaData globalMetaData = ParquetFileWriter.getGlobalMetaData(footers, strictTypeChecking);
        ReadSupport.ReadContext readContext = this.getReadSupport(configuration).init(new InitContext(configuration, globalMetaData.getKeyValueMetaData(), globalMetaData.getSchema()));
        return new ClientSideMetadataSplitStrategy().getSplits(configuration, footers, maxSplitSize, minSplitSize, readContext);
    }

    protected List<FileStatus> listStatus(JobContext jobContext) throws IOException {
        return ParquetInputFormat.getAllFileRecursively(super.listStatus(jobContext), ContextUtil.getConfiguration(jobContext));
    }

    private static List<FileStatus> getAllFileRecursively(List<FileStatus> files, Configuration conf) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        for (FileStatus file : files) {
            if (file.isDir()) {
                Path p = file.getPath();
                FileSystem fs = p.getFileSystem(conf);
                ParquetInputFormat.staticAddInputPathRecursively(result, fs, p, HiddenFileFilter.INSTANCE);
                continue;
            }
            result.add(file);
        }
        LOG.info("Total input paths to process : {}", (Object)result.size());
        return result;
    }

    private static void staticAddInputPathRecursively(List<FileStatus> result, FileSystem fs, Path path, PathFilter inputFilter) throws IOException {
        for (FileStatus stat : fs.listStatus(path, inputFilter)) {
            if (stat.isDir()) {
                ParquetInputFormat.staticAddInputPathRecursively(result, fs, stat.getPath(), inputFilter);
                continue;
            }
            result.add(stat);
        }
    }

    public List<Footer> getFooters(JobContext jobContext) throws IOException {
        List<FileStatus> statuses = this.listStatus(jobContext);
        if (statuses.isEmpty()) {
            return Collections.emptyList();
        }
        Configuration config = ContextUtil.getConfiguration(jobContext);
        LinkedHashMap<FileStatusWrapper, Footer> footersMap = new LinkedHashMap<FileStatusWrapper, Footer>();
        HashSet<FileStatus> missingStatuses = new HashSet<FileStatus>();
        HashMap<Path, FileStatusWrapper> missingStatusesMap = new HashMap<Path, FileStatusWrapper>(missingStatuses.size());
        if (this.footersCache == null) {
            this.footersCache = new LruCache(Math.max(statuses.size(), 100));
        }
        for (FileStatus status : statuses) {
            FileStatusWrapper fileStatusWrapper = new FileStatusWrapper(status);
            FootersCacheValue cacheEntry = this.footersCache.getCurrentValue(fileStatusWrapper);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache entry " + (cacheEntry == null ? "not " : "") + " found for '" + status.getPath() + "'");
            }
            if (cacheEntry != null) {
                footersMap.put(fileStatusWrapper, cacheEntry.getFooter());
                continue;
            }
            footersMap.put(fileStatusWrapper, null);
            missingStatuses.add(status);
            missingStatusesMap.put(status.getPath(), fileStatusWrapper);
        }
        LOG.debug("found {} footers in cache and adding up to {} missing footers to the cache", (Object)footersMap.size(), (Object)missingStatuses.size());
        if (!missingStatuses.isEmpty()) {
            List<Footer> newFooters = this.getFooters(config, missingStatuses);
            for (Footer footer : newFooters) {
                FileStatusWrapper fileStatus = (FileStatusWrapper)missingStatusesMap.get(footer.getFile());
                this.footersCache.put(fileStatus, new FootersCacheValue(fileStatus, footer));
            }
        }
        ArrayList<Footer> footers = new ArrayList<Footer>(statuses.size());
        for (Map.Entry entry : footersMap.entrySet()) {
            Footer footer = (Footer)entry.getValue();
            if (footer == null) {
                footers.add(this.footersCache.getCurrentValue((FileStatusWrapper)entry.getKey()).getFooter());
                continue;
            }
            footers.add(footer);
        }
        return footers;
    }

    public List<Footer> getFooters(Configuration configuration, List<FileStatus> statuses) throws IOException {
        return this.getFooters(configuration, (Collection<FileStatus>)statuses);
    }

    public List<Footer> getFooters(Configuration configuration, Collection<FileStatus> statuses) throws IOException {
        LOG.debug("reading {} files", (Object)statuses.size());
        boolean taskSideMetaData = ParquetInputFormat.isTaskSideMetaData(configuration);
        return ParquetFileReader.readAllFootersInParallelUsingSummaryFiles(configuration, statuses, taskSideMetaData);
    }

    public GlobalMetaData getGlobalMetaData(JobContext jobContext) throws IOException {
        return ParquetFileWriter.getGlobalMetaData(this.getFooters(jobContext));
    }

    static final class FileStatusWrapper {
        private final FileStatus status;

        public FileStatusWrapper(FileStatus fileStatus) {
            if (fileStatus == null) {
                throw new IllegalArgumentException("FileStatus object cannot be null");
            }
            this.status = fileStatus;
        }

        public long getModificationTime() {
            return this.status.getModificationTime();
        }

        public int hashCode() {
            return this.status.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof FileStatusWrapper && this.status.equals((Object)((FileStatusWrapper)other).status);
        }

        public String toString() {
            return this.status.getPath().toString();
        }
    }

    static final class FootersCacheValue
    implements LruCache.Value<FileStatusWrapper, FootersCacheValue> {
        private final long modificationTime;
        private final Footer footer;

        public FootersCacheValue(FileStatusWrapper status, Footer footer) {
            this.modificationTime = status.getModificationTime();
            this.footer = new Footer(footer.getFile(), footer.getParquetMetadata());
        }

        @Override
        public boolean isCurrent(FileStatusWrapper key) {
            boolean isCurrent;
            long currentModTime = key.getModificationTime();
            boolean bl = isCurrent = this.modificationTime >= currentModTime;
            if (LOG.isDebugEnabled() && !isCurrent) {
                LOG.debug("The cache value for '{}' is not current: cached modification time={}, current modification time: {}", new Object[]{key, this.modificationTime, currentModTime});
            }
            return isCurrent;
        }

        public Footer getFooter() {
            return this.footer;
        }

        @Override
        public boolean isNewerThan(FootersCacheValue otherValue) {
            return otherValue == null || this.modificationTime > otherValue.modificationTime;
        }

        public Path getPath() {
            return this.footer.getFile();
        }
    }
}

