/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.connector.kafka.sink;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.InitContextInitializationContextAdapter;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.api.connector.sink.SinkWriter;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.table.store.shaded.connector.kafka.sink.KafkaCommittable;
import org.apache.flink.table.store.shaded.connector.kafka.sink.KafkaCommittableSerializer;
import org.apache.flink.table.store.shaded.connector.kafka.sink.KafkaCommitter;
import org.apache.flink.table.store.shaded.connector.kafka.sink.KafkaRecordSerializationSchema;
import org.apache.flink.table.store.shaded.connector.kafka.sink.KafkaSinkBuilder;
import org.apache.flink.table.store.shaded.connector.kafka.sink.KafkaWriter;
import org.apache.flink.table.store.shaded.connector.kafka.sink.KafkaWriterState;
import org.apache.flink.table.store.shaded.connector.kafka.sink.KafkaWriterStateSerializer;

@PublicEvolving
public class KafkaSink<IN>
implements Sink<IN, KafkaCommittable, KafkaWriterState, Void> {
    private final DeliveryGuarantee deliveryGuarantee;
    private final KafkaRecordSerializationSchema<IN> recordSerializer;
    private final Properties kafkaProducerConfig;
    private final String transactionalIdPrefix;

    KafkaSink(DeliveryGuarantee deliveryGuarantee, Properties kafkaProducerConfig, String transactionalIdPrefix, KafkaRecordSerializationSchema<IN> recordSerializer) {
        this.deliveryGuarantee = deliveryGuarantee;
        this.kafkaProducerConfig = kafkaProducerConfig;
        this.transactionalIdPrefix = transactionalIdPrefix;
        this.recordSerializer = recordSerializer;
    }

    public static <IN> KafkaSinkBuilder<IN> builder() {
        return new KafkaSinkBuilder();
    }

    public SinkWriter<IN, KafkaCommittable, KafkaWriterState> createWriter(Sink.InitContext context, List<KafkaWriterState> states) throws IOException {
        Supplier<MetricGroup> metricGroupSupplier = () -> context.metricGroup().addGroup("user");
        return new KafkaWriter<IN>(this.deliveryGuarantee, this.kafkaProducerConfig, this.transactionalIdPrefix, context, this.recordSerializer, (SerializationSchema.InitializationContext)new InitContextInitializationContextAdapter(context.getUserCodeClassLoader(), metricGroupSupplier), states);
    }

    public Optional<Committer<KafkaCommittable>> createCommitter() throws IOException {
        return Optional.of(new KafkaCommitter(this.kafkaProducerConfig));
    }

    public Optional<GlobalCommitter<KafkaCommittable, Void>> createGlobalCommitter() throws IOException {
        return Optional.empty();
    }

    public Optional<SimpleVersionedSerializer<KafkaCommittable>> getCommittableSerializer() {
        return Optional.of(new KafkaCommittableSerializer());
    }

    public Optional<SimpleVersionedSerializer<Void>> getGlobalCommittableSerializer() {
        return Optional.empty();
    }

    public Optional<SimpleVersionedSerializer<KafkaWriterState>> getWriterStateSerializer() {
        return Optional.of(new KafkaWriterStateSerializer());
    }
}

