/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplit;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplitGenerator;
import org.apache.flink.table.store.connector.source.FlinkSource;
import org.apache.flink.table.store.connector.source.PendingSplitsCheckpoint;
import org.apache.flink.table.store.connector.source.StaticFileStoreSplitEnumerator;
import org.apache.flink.table.store.file.Snapshot;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.DataTable;
import org.apache.flink.table.store.table.source.DataTableScan;
import org.apache.flink.table.store.table.source.snapshot.StaticDataFileSnapshotEnumerator;

public class StaticFileStoreSource
extends FlinkSource {
    private static final long serialVersionUID = 3L;
    private final DataTable table;
    private final StaticDataFileSnapshotEnumerator.Factory enumeratorFactory;

    public StaticFileStoreSource(DataTable table, @Nullable int[][] projectedFields, @Nullable Predicate predicate, @Nullable Long limit) {
        this(table, projectedFields, predicate, limit, StaticDataFileSnapshotEnumerator::create);
    }

    public StaticFileStoreSource(DataTable table, @Nullable int[][] projectedFields, @Nullable Predicate predicate, @Nullable Long limit, StaticDataFileSnapshotEnumerator.Factory enumeratorFactory) {
        super(table, projectedFields, predicate, limit);
        this.table = table;
        this.enumeratorFactory = enumeratorFactory;
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SplitEnumerator<FileStoreSourceSplit, PendingSplitsCheckpoint> restoreEnumerator(SplitEnumeratorContext<FileStoreSourceSplit> context, PendingSplitsCheckpoint checkpoint) {
        ArrayList<FileStoreSourceSplit> splits;
        SnapshotManager snapshotManager = this.table.snapshotManager();
        DataTableScan scan = this.table.newScan();
        if (this.predicate != null) {
            scan.withFilter(this.predicate);
        }
        Long snapshotId = null;
        if (checkpoint == null) {
            DataTableScan.DataFilePlan plan;
            splits = new ArrayList();
            FileStoreSourceSplitGenerator splitGenerator = new FileStoreSourceSplitGenerator();
            StaticDataFileSnapshotEnumerator snapshotEnumerator = this.enumeratorFactory.create(this.table, scan);
            while ((plan = snapshotEnumerator.enumerate()) != null) {
                snapshotId = plan.snapshotId;
                splits.addAll(splitGenerator.createSplits(plan));
            }
        } else {
            snapshotId = checkpoint.currentSnapshotId();
            splits = checkpoint.splits();
        }
        Snapshot snapshot = snapshotId == null ? null : snapshotManager.snapshot(snapshotId);
        return new StaticFileStoreSplitEnumerator(context, snapshot, splits);
    }
}

