/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.connector.source.FileStoreSourceReader;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplit;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplitSerializer;
import org.apache.flink.table.store.connector.source.PendingSplitsCheckpoint;
import org.apache.flink.table.store.connector.source.PendingSplitsCheckpointSerializer;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.table.Table;
import org.apache.flink.table.store.table.source.TableRead;

public abstract class FlinkSource
implements Source<RowData, FileStoreSourceSplit, PendingSplitsCheckpoint> {
    private static final long serialVersionUID = 1L;
    protected final Table table;
    @Nullable
    protected final int[][] projectedFields;
    @Nullable
    protected final Predicate predicate;
    @Nullable
    protected final Long limit;

    public FlinkSource(Table table, @Nullable int[][] projectedFields, @Nullable Predicate predicate, @Nullable Long limit) {
        this.table = table;
        this.projectedFields = projectedFields;
        this.predicate = predicate;
        this.limit = limit;
    }

    public SourceReader<RowData, FileStoreSourceSplit> createReader(SourceReaderContext context) {
        TableRead read = this.table.newRead();
        if (this.projectedFields != null) {
            read.withProjection(this.projectedFields);
        }
        if (this.predicate != null) {
            read.withFilter(this.predicate);
        }
        return new FileStoreSourceReader(context, read, this.limit);
    }

    public SplitEnumerator<FileStoreSourceSplit, PendingSplitsCheckpoint> createEnumerator(SplitEnumeratorContext<FileStoreSourceSplit> context) throws Exception {
        return this.restoreEnumerator(context, null);
    }

    public FileStoreSourceSplitSerializer getSplitSerializer() {
        return new FileStoreSourceSplitSerializer();
    }

    public PendingSplitsCheckpointSerializer getEnumeratorCheckpointSerializer() {
        return new PendingSplitsCheckpointSerializer(this.getSplitSerializer());
    }
}

