/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.example;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.table.store.shaded.org.apache.parquet.example.data.Group;
import org.apache.flink.table.store.shaded.org.apache.parquet.example.data.GroupWriter;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.api.RecordConsumer;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.MessageType;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.MessageTypeParser;
import org.apache.hadoop.conf.Configuration;

public class GroupWriteSupport
extends WriteSupport<Group> {
    public static final String PARQUET_EXAMPLE_SCHEMA = "parquet.example.schema";
    private MessageType schema;
    private GroupWriter groupWriter;
    private Map<String, String> extraMetaData;

    public static void setSchema(MessageType schema, Configuration configuration) {
        configuration.set(PARQUET_EXAMPLE_SCHEMA, schema.toString());
    }

    public static MessageType getSchema(Configuration configuration) {
        return MessageTypeParser.parseMessageType(Objects.requireNonNull(configuration.get(PARQUET_EXAMPLE_SCHEMA), PARQUET_EXAMPLE_SCHEMA));
    }

    public GroupWriteSupport() {
        this(null, new HashMap<String, String>());
    }

    GroupWriteSupport(MessageType schema) {
        this(schema, new HashMap<String, String>());
    }

    GroupWriteSupport(MessageType schema, Map<String, String> extraMetaData) {
        this.schema = schema;
        this.extraMetaData = extraMetaData;
    }

    @Override
    public String getName() {
        return "example";
    }

    @Override
    public WriteSupport.WriteContext init(Configuration configuration) {
        if (this.schema == null) {
            this.schema = GroupWriteSupport.getSchema(configuration);
        }
        return new WriteSupport.WriteContext(this.schema, this.extraMetaData);
    }

    @Override
    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.groupWriter = new GroupWriter(recordConsumer, this.schema);
    }

    @Override
    public void write(Group record) {
        this.groupWriter.write(record);
    }
}

