/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Objects;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin.UserScramCredentialAlteration;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.security.scram.internals.ScramFormatter;

public class UserScramCredentialUpsertion
extends UserScramCredentialAlteration {
    private final ScramCredentialInfo info;
    private final byte[] salt;
    private final byte[] password;

    public UserScramCredentialUpsertion(String user, ScramCredentialInfo credentialInfo, String password) {
        this(user, credentialInfo, password.getBytes(StandardCharsets.UTF_8));
    }

    public UserScramCredentialUpsertion(String user, ScramCredentialInfo credentialInfo, byte[] password) {
        this(user, credentialInfo, password, UserScramCredentialUpsertion.generateRandomSalt());
    }

    public UserScramCredentialUpsertion(String user, ScramCredentialInfo credentialInfo, byte[] password, byte[] salt) {
        super(Objects.requireNonNull(user));
        this.info = Objects.requireNonNull(credentialInfo);
        this.password = Objects.requireNonNull(password);
        this.salt = Objects.requireNonNull(salt);
    }

    public ScramCredentialInfo credentialInfo() {
        return this.info;
    }

    public byte[] salt() {
        return this.salt;
    }

    public byte[] password() {
        return this.password;
    }

    private static byte[] generateRandomSalt() {
        return ScramFormatter.secureRandomBytes(new SecureRandom());
    }
}

