/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.KafkaFuture;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.Errors;

@InterfaceStability.Evolving
public class AlterConsumerGroupOffsetsResult {
    private final KafkaFuture<Map<TopicPartition, Errors>> future;

    AlterConsumerGroupOffsetsResult(KafkaFuture<Map<TopicPartition, Errors>> future) {
        this.future = future;
    }

    public KafkaFuture<Void> partitionResult(final TopicPartition partition) {
        final KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.future.whenComplete(new KafkaFuture.BiConsumer<Map<TopicPartition, Errors>, Throwable>(){

            @Override
            public void accept(Map<TopicPartition, Errors> topicPartitions, Throwable throwable) {
                if (throwable != null) {
                    result.completeExceptionally(throwable);
                } else if (!topicPartitions.containsKey(partition)) {
                    result.completeExceptionally(new IllegalArgumentException("Alter offset for partition \"" + partition + "\" was not attempted"));
                } else {
                    Errors error = topicPartitions.get(partition);
                    if (error == Errors.NONE) {
                        result.complete(null);
                    } else {
                        result.completeExceptionally(error.exception());
                    }
                }
            }
        });
        return result;
    }

    public KafkaFuture<Void> all() {
        return this.future.thenApply(new KafkaFuture.BaseFunction<Map<TopicPartition, Errors>, Void>(){

            @Override
            public Void apply(Map<TopicPartition, Errors> topicPartitionErrorsMap) {
                List partitionsFailed = topicPartitionErrorsMap.entrySet().stream().filter(e -> e.getValue() != Errors.NONE).map(Map.Entry::getKey).collect(Collectors.toList());
                for (Errors error : topicPartitionErrorsMap.values()) {
                    if (error == Errors.NONE) continue;
                    throw error.exception("Failed altering consumer group offsets for the following partitions: " + partitionsFailed);
                }
                return null;
            }
        });
    }
}

