/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.table.store.utils.RowDataToObjectArrayConverter;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class FieldStatsCollector {
    private final Object[] minValues;
    private final Object[] maxValues;
    private final long[] nullCounts;
    private final RowDataToObjectArrayConverter converter;
    private final TypeSerializer<Object>[] fieldSerializers;

    public FieldStatsCollector(RowType rowType) {
        int numFields = rowType.getFieldCount();
        this.minValues = new Object[numFields];
        this.maxValues = new Object[numFields];
        this.nullCounts = new long[numFields];
        this.converter = new RowDataToObjectArrayConverter(rowType);
        this.fieldSerializers = new TypeSerializer[numFields];
        for (int i = 0; i < numFields; ++i) {
            this.fieldSerializers[i] = InternalSerializers.create((LogicalType)rowType.getTypeAt(i));
        }
    }

    public void collect(RowData row) {
        Object[] objects = this.converter.convert(row);
        for (int i = 0; i < row.getArity(); ++i) {
            Object obj = objects[i];
            if (obj == null) {
                int n = i;
                this.nullCounts[n] = this.nullCounts[n] + 1L;
                continue;
            }
            if (!(obj instanceof Comparable)) continue;
            Comparable c = (Comparable)obj;
            if (this.minValues[i] == null || c.compareTo(this.minValues[i]) < 0) {
                this.minValues[i] = this.fieldSerializers[i].copy((Object)c);
            }
            if (this.maxValues[i] != null && c.compareTo(this.maxValues[i]) <= 0) continue;
            this.maxValues[i] = this.fieldSerializers[i].copy((Object)c);
        }
    }

    public FieldStats[] extract() {
        FieldStats[] stats = new FieldStats[this.nullCounts.length];
        for (int i = 0; i < stats.length; ++i) {
            stats[i] = new FieldStats(this.minValues[i], this.maxValues[i], this.nullCounts[i]);
        }
        return stats;
    }
}

