/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import java.io.IOException;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.file.utils.AtomicFsDataOutputStream;
import org.apache.flink.table.store.file.utils.FileUtils;

public class RenamingAtomicFsDataOutputStream
extends AtomicFsDataOutputStream {
    private final FileSystem fs;
    private final Path targetFile;
    private final Path tempFile;
    private final FSDataOutputStream out;

    public RenamingAtomicFsDataOutputStream(FileSystem fs, Path targetFile, Path tempFile) throws IOException {
        this.fs = fs;
        this.targetFile = targetFile;
        this.tempFile = tempFile;
        this.out = fs.create(tempFile, FileSystem.WriteMode.OVERWRITE);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void sync() throws IOException {
        this.out.sync();
    }

    public long getPos() throws IOException {
        return this.out.getPos();
    }

    @Override
    public boolean closeAndCommit() throws IOException {
        FileStatus srcStatus;
        long offset = this.getPos();
        this.out.close();
        try {
            srcStatus = this.fs.getFileStatus(this.tempFile);
        }
        catch (IOException e) {
            throw new IOException("Cannot clean commit: Staging file does not exist.");
        }
        if (srcStatus.getLen() != offset) {
            throw new IOException("Cannot clean commit: File has trailing junk data.");
        }
        try {
            boolean success = this.fs.rename(this.tempFile, this.targetFile);
            if (success) {
                return true;
            }
            FileUtils.deleteOrWarn(this.tempFile);
            return false;
        }
        catch (IOException e) {
            FileUtils.deleteOrWarn(this.tempFile);
            throw new IOException("Committing file by rename failed: " + this.tempFile + " to " + this.targetFile, e);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        FileUtils.deleteOrWarn(this.tempFile);
    }
}

