/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.io.DataFilePathFactory;
import org.apache.flink.table.store.file.utils.RowDataPartitionComputer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.util.Preconditions;

@ThreadSafe
public class FileStorePathFactory {
    public static final ConfigOption<String> PARTITION_DEFAULT_NAME = ConfigOptions.key((String)"partition.default-name").stringType().defaultValue((Object)"__DEFAULT_PARTITION__").withDescription("The default partition name in case the dynamic partition column value is null/empty string.");
    private final Path root;
    private final String uuid;
    private final RowDataPartitionComputer partitionComputer;
    private final String formatIdentifier;
    private final AtomicInteger manifestFileCount;
    private final AtomicInteger manifestListCount;

    public FileStorePathFactory(Path root) {
        this(root, RowType.of((LogicalType[])new LogicalType[0]), (String)PARTITION_DEFAULT_NAME.defaultValue(), (String)CoreOptions.FILE_FORMAT.defaultValue());
    }

    public FileStorePathFactory(Path root, RowType partitionType, String defaultPartValue, String formatIdentifier) {
        this.root = root;
        this.uuid = UUID.randomUUID().toString();
        this.partitionComputer = FileStorePathFactory.getPartitionComputer(partitionType, defaultPartValue);
        this.formatIdentifier = formatIdentifier;
        this.manifestFileCount = new AtomicInteger(0);
        this.manifestListCount = new AtomicInteger(0);
    }

    public Path root() {
        return this.root;
    }

    @VisibleForTesting
    public static RowDataPartitionComputer getPartitionComputer(RowType partitionType, String defaultPartValue) {
        String[] partitionColumns = partitionType.getFieldNames().toArray(new String[0]);
        return new RowDataPartitionComputer(defaultPartValue, partitionType, partitionColumns);
    }

    public Path newManifestFile() {
        return new Path(this.root + "/manifest/manifest-" + this.uuid + "-" + this.manifestFileCount.getAndIncrement());
    }

    public Path newManifestList() {
        return new Path(this.root + "/manifest/manifest-list-" + this.uuid + "-" + this.manifestListCount.getAndIncrement());
    }

    public Path toManifestFilePath(String manifestFileName) {
        return new Path(this.root + "/manifest/" + manifestFileName);
    }

    public Path toManifestListPath(String manifestListName) {
        return new Path(this.root + "/manifest/" + manifestListName);
    }

    public DataFilePathFactory createDataFilePathFactory(BinaryRowData partition, int bucket) {
        return new DataFilePathFactory(this.root, this.getPartitionString(partition), bucket, this.formatIdentifier);
    }

    public Path bucketPath(BinaryRowData partition, int bucket) {
        return DataFilePathFactory.bucketPath(this.root, this.getPartitionString(partition), bucket);
    }

    public String getPartitionString(BinaryRowData partition) {
        return PartitionPathUtils.generatePartitionPath(this.partitionComputer.generatePartValues((RowData)Preconditions.checkNotNull((Object)partition, (String)"Partition row data is null. This is unexpected.")));
    }

    @VisibleForTesting
    public String uuid() {
        return this.uuid;
    }
}

